/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.xml;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.sequencer.xml.AbstractXmlSequencerTest;

public class XmlSequencerTest
extends AbstractXmlSequencerTest {
    @Test
    public void shouldHandleNamespaces() throws Exception {
        Node document = this.sequenceAndAssertDocument("master.xml");
        this.assertProperty(document, "book[1]/bookinfo[1]/xi:include[1]", "jcr:primaryType", "modexml:element");
        this.assertProperty(document, "book[1]/bookinfo[1]/xi:include[1]", "href", "Author_Group.xml");
        this.assertProperty(document, "book[1]/bookinfo[1]/xi:include[2]", "jcr:primaryType", "modexml:element");
        this.assertProperty(document, "book[1]/bookinfo[1]/xi:include[2]", "href", "Legal_Notice.xml");
    }

    @Test
    public void shouldSequenceEntityDeclarations() throws Exception {
        Node document = this.sequenceAndAssertDocument("master.xml");
        this.assertProperty(document, "modedtd:entity[1]", "jcr:primaryType", "modedtd:entity");
        this.assertProperty(document, "modedtd:entity[1]", "modedtd:name", "%RH-ENTITIES");
        this.assertProperty(document, "modedtd:entity[1]", "modedtd:systemId", "Common_Config/rh-entities.ent");
        this.assertProperty(document, "modedtd:entity[2]", "jcr:primaryType", "modedtd:entity");
        this.assertProperty(document, "modedtd:entity[2]", "modedtd:name", "versionNumber");
        this.assertProperty(document, "modedtd:entity[2]", "modedtd:value", "0.1");
        this.assertProperty(document, "modedtd:entity[3]", "jcr:primaryType", "modedtd:entity");
        this.assertProperty(document, "modedtd:entity[3]", "modedtd:name", "copyrightYear");
        this.assertProperty(document, "modedtd:entity[3]", "modedtd:value", "2008");
    }

    @Test
    public void shouldSequenceElementContent() throws Exception {
        Node document = this.sequenceAndAssertDocument("master.xml");
        this.assertProperty(document, "book[1]/chapter[1]/para[8]/modexml:elementContent[1]", "modexml:elementContent", "ModeShape is building other features as well. One goal of ModeShape is to create federated repositories that dynamically merge the information from multiple databases, services, applications, and other JCR repositories. Another is to create customized views based upon the type of data and the role of the user that is accessing the data. And yet another is to create a REST-ful API to allow the JCR content to be accessed easily by other applications written in other languages.");
    }

    @Test
    public void shouldSequenceCData() throws Exception {
        Node document = this.sequenceAndAssertDocument("CurrencyFormatterExample.mxml");
        this.assertProperty(document, "mx:Application[1]/mx:Script[1]/modexml:cData[1]", "modexml:cDataContent", "\n\n              import mx.events.ValidationResultEvent;\t\t\t\n              private var vResult:ValidationResultEvent;\n\t\t\t\n              // Event handler to validate and format input.\n              private function Format():void {\n              \n                    vResult = numVal.validate();\n\n                    if (vResult.type==ValidationResultEvent.VALID) {\n                        var temp:Number=Number(priceUS.text); \n                        formattedUSPrice.text= usdFormatter.format(temp);\n                    }\n                    \n                    else {\n                       formattedUSPrice.text=\"\";\n                    }\n              }\n        ");
    }

    @Test
    public void shouldSequenceProcessingInstructions() throws Exception {
        Node document = this.sequenceAndAssertDocument("plugin.xml");
        this.assertProperty(document, "modexml:processingInstruction[1]", "jcr:primaryType", "modexml:processingInstruction");
        this.assertProperty(document, "modexml:processingInstruction[1]", "modexml:target", "eclipse");
        this.assertProperty(document, "modexml:processingInstruction[1]", "modexml:processingInstructionContent", "version=\"3.0\"");
    }

    @Test
    public void shouldSequenceXmlDocumentWithoutNamespaces() throws Exception {
        Node document = this.sequenceAndAssertDocument("docWithoutNamespaces.xml");
        this.assertElement(document, "Cars", new String[0]);
        this.assertElement(document, "Cars/Hybrid", new String[0]);
        this.assertElement(document, "Cars/Hybrid/car[1]", "name=Toyota Prius", "maker=Toyota", "model=Prius");
        this.assertElement(document, "Cars/Hybrid/car[2]", "name=Toyota Highlander", "maker=Toyota", "model=Highlander");
        this.assertElement(document, "Cars/Hybrid/car[3]", "name=Nissan Altima", "maker=Nissan", "model=Altima");
        this.assertElement(document, "Cars/Sports", new String[0]);
        this.assertElement(document, "Cars/Sports/car[1]", "name=Aston Martin DB9", "maker=Aston Martin", "model=DB9");
        this.assertElement(document, "Cars/Sports/car[2]", "name=Infiniti G37", "maker=Infiniti", "model=G37");
    }

    @Test
    public void shouldSequenceXmlDocumentWithNamespaces() throws Exception {
        this.registerDefaultNamespace();
        Node document = this.sequenceAndAssertDocument("docWithNamespaces.xml");
        this.assertElement(document, "c:Cars", new String[0]);
        this.assertElement(document, "c:Cars/c:Hybrid", new String[0]);
        this.assertElement(document, "c:Cars/c:Hybrid/c:car[1]", "maker=Toyota", "model=Prius");
        this.assertElement(document, "c:Cars/c:Hybrid/c:car[2]", "maker=Toyota", "model=Highlander");
        this.assertElement(document, "c:Cars/c:Hybrid/c:car[3]", "maker=Nissan", "model=Altima");
        this.assertElement(document, "c:Cars/c:Sports", new String[0]);
        this.assertElement(document, "c:Cars/c:Sports/c:car[1]", "maker=Aston Martin", "model=DB9");
        this.assertElement(document, "c:Cars/c:Sports/c:car[2]", "maker=Infiniti", "model=G37");
    }

    @Test
    public void shouldSequenceXmlDocumentWithNestedNamespaceDeclarations() throws Exception {
        this.registerDefaultNamespace();
        Node document = this.sequenceAndAssertDocument("docWithNestedNamespaces.xml");
        this.assertElement(document, "Cars", new String[0]);
        this.assertElement(document, "Cars/c:Hybrid", new String[0]);
        this.assertElement(document, "Cars/c:Hybrid/c:car[1]", "maker=Toyota", "model=Prius");
        this.assertElement(document, "Cars/c:Hybrid/c:car[2]", "maker=Toyota", "model=Highlander");
        this.assertElement(document, "Cars/c:Hybrid/c:car[3]", "maker=Nissan", "model=Altima");
        this.assertElement(document, "Cars/Sports", new String[0]);
        this.assertElement(document, "Cars/Sports/car[1]", "info:maker=Aston Martin", "model=DB9");
        this.assertElement(document, "Cars/Sports/car[2]", "info:maker=Infiniti", "model=G37");
    }

    @Test
    public void shouldSequenceXmlDocumentThatContainsNoContent() throws Exception {
        Node document = this.sequenceAndAssertDocument("docWithOnlyRootElement.xml");
        Node cars = this.assertElement(document, "Cars", new String[0]);
        Assert.assertEquals((long)0L, (long)cars.getNodes().getSize());
    }

    @Test
    public void shouldSequenceXmlDocumentWithXmlComments() throws Exception {
        this.registerDefaultNamespace();
        Node document = this.sequenceAndAssertDocument("docWithComments.xml");
        this.assertElement(document, "c:Cars", new String[0]);
        this.assertComment(document, "c:Cars", 1, "This is a comment");
        this.assertElement(document, "c:Cars/c:Hybrid", new String[0]);
        this.assertElement(document, "c:Cars/c:Hybrid/c:car[1]", "maker=Toyota", "model=Prius");
        this.assertElement(document, "c:Cars/c:Hybrid/c:car[2]", "maker=Toyota", "model=Highlander");
        this.assertElement(document, "c:Cars/c:Hybrid/c:car[3]", "maker=Nissan", "model=Altima");
        this.assertComment(document, "c:Cars", 2, "This is another comment");
        this.assertElement(document, "c:Cars/c:Sports", new String[0]);
        this.assertElement(document, "c:Cars/c:Sports/c:car[1]", "maker=Aston Martin", "model=DB9");
        this.assertElement(document, "c:Cars/c:Sports/c:car[2]", "maker=Infiniti", "model=G37");
    }

    @Test
    public void shouldSequenceXmlDocumentWithXmlElementsContainingOnlyChildElements() throws Exception {
        Node document = this.sequenceAndAssertDocument("docWithElementsContainingElements.xml");
        this.assertElement(document, "xhtml:html", new String[0]);
        this.assertElement(document, "xhtml:html/xhtml:head", new String[0]);
        this.assertElement(document, "xhtml:html/xhtml:head/xhtml:title", new String[0]);
        this.assertContent(document, "xhtml:html/xhtml:head/xhtml:title", 1, "Three Namespaces");
        this.assertElement(document, "xhtml:html/xhtml:body", new String[0]);
        this.assertElement(document, "xhtml:html/xhtml:body/xhtml:h1", "{}align=center");
        this.assertContent(document, "xhtml:html/xhtml:body/xhtml:h1", 1, "An Ellipse and a Rectangle");
        this.assertElement(document, "xhtml:html/xhtml:body/svg:svg", "{}width=12cm", "{}height=10cm");
        this.assertElement(document, "xhtml:html/xhtml:body/svg:svg/svg:ellipse", "{}rx=110", "{}ry=130");
        this.assertElement(document, "xhtml:html/xhtml:body/svg:svg/svg:rect", "{}x=4cm", "{}y=1cm", "{}width=3cm", "{}height=6cm");
        this.assertElement(document, "xhtml:html/xhtml:body/xhtml:p", new String[0]);
        this.assertContent(document, "xhtml:html/xhtml:body/xhtml:p", 1, "The equation for ellipses");
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math", new String[0]);
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply", new String[0]);
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:eq", new String[0]);
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:cn", new String[0]);
        this.assertContent(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:cn", 1, "1");
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply", new String[0]);
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:plus", new String[0]);
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply", new String[0]);
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:divide", new String[0]);
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply", new String[0]);
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply/mathml:power", new String[0]);
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply/mathml:ci", new String[0]);
        this.assertContent(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply/mathml:ci", 1, "x");
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply/mathml:cn", new String[0]);
        this.assertContent(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply/mathml:cn", 1, "2");
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply[2]", new String[0]);
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply[2]/mathml:power", new String[0]);
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply[2]/mathml:ci", new String[0]);
        this.assertContent(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply[2]/mathml:ci", 1, "a");
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply[2]/mathml:cn", new String[0]);
        this.assertContent(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply[2]/mathml:cn", 1, "2");
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]", new String[0]);
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:divide", new String[0]);
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply", new String[0]);
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply/mathml:power", new String[0]);
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply/mathml:ci", new String[0]);
        this.assertContent(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply/mathml:ci", 1, "y");
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply/mathml:cn", new String[0]);
        this.assertContent(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply/mathml:cn", 1, "2");
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply[2]", new String[0]);
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply[2]/mathml:power", new String[0]);
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply[2]/mathml:ci", new String[0]);
        this.assertContent(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply[2]/mathml:ci", 1, "b");
        this.assertElement(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply[2]/mathml:cn", new String[0]);
        this.assertContent(document, "xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply[2]/mathml:cn", 1, "2");
        this.assertElement(document, "xhtml:html/xhtml:body/xhtml:hr", new String[0]);
        this.assertElement(document, "xhtml:html/xhtml:body/xhtml:p[2]", new String[0]);
        this.assertContent(document, "xhtml:html/xhtml:body/xhtml:p[2]", 1, "Last Modified January 10, 2002");
    }

    @Test
    public void shouldParseXmlDocumentWithDtdEntities() throws Exception {
        String longContent = "This is some long content that spans multiple lines and should span multiple calls to 'character(...)'. Repeating to make really long. This is some long content that spans multiple lines and should span multiple calls to 'character(...)'. Repeating to make really long. This is some long content that spans multiple lines and should span multiple calls to 'character(...)'. Repeating to make really long. This is some long content that spans multiple lines and should span multiple calls to 'character(...)'. Repeating to make really long.";
        Node document = this.sequenceAndAssertDocument("docWithDtdEntities.xml", "book", "-//OASIS//DTD DocBook XML V4.4//EN", "http://www.oasis-open.org/docbook/xml/4.4/docbookx.dtd");
        this.assertComment(document, null, 1, "Document comment");
        this.assertEntity(document, 1, "%RH-ENTITIES", null, "Common_Config/rh-entities.ent");
        this.assertEntity(document, 2, "versionNumber", "0.1");
        this.assertEntity(document, 3, "copyrightYear", "2008");
        this.assertEntity(document, 4, "copyrightHolder", "Red Hat Middleware, LLC.");
        this.assertElement(document, "book", new String[0]);
        this.assertElement(document, "book/bookinfo", new String[0]);
        this.assertElement(document, "book/bookinfo/title", new String[0]);
        this.assertContent(document, "book/bookinfo/title", 1, "ModeShape");
        this.assertElement(document, "book/bookinfo/releaseinfo", new String[0]);
        this.assertContent(document, "book/bookinfo/releaseinfo", 1, "&versionNumber;");
        this.assertElement(document, "book/bookinfo/productnumber", new String[0]);
        this.assertContent(document, "book/bookinfo/productnumber", 1, "some text with &versionNumber;inside");
        this.assertElement(document, "book/bookinfo/abstract", new String[0]);
        this.assertContent(document, "book/bookinfo/abstract", 1, longContent);
        this.assertElement(document, "book/programlisting1", new String[0]);
        this.assertContent(document, "book/programlisting1", 1, "&lt;dependency&gt; &lt;/dependency&gt;");
        this.assertElement(document, "book/programlisting2", new String[0]);
        this.assertCData(document, "book/programlisting2", 1, "\n&lt;dependency&gt;\n&lt;/dependency&gt;\n");
        this.assertElement(document, "book/programlisting3", new String[0]);
        this.assertContent(document, "book/programlisting3", 1, "mixture of text and");
        this.assertCData(document, "book/programlisting3", 1, "\n&lt;dependency&gt;\n&lt;/dependency&gt;\n");
        this.assertContent(document, "book/programlisting3", 2, "and some text");
        this.assertComment(document, "book/programlisting3", 1, "comment in content");
        this.assertContent(document, "book/programlisting3", 3, "after.");
    }

    @Test
    public void shouldParseXmlDocumentWithProcessingInstructions() throws Exception {
        Node document = this.sequenceAndAssertDocument("docWithProcessingInstructions.xml");
        this.assertProcessingInstruction(document, 1, "target", "content");
        this.assertProcessingInstruction(document, 2, "target2", "other stuff in the processing instruction");
        this.assertElement(document, "Cars", new String[0]);
        this.assertComment(document, "Cars", 1, "This is a comment");
        this.assertElement(document, "Cars/Hybrid", new String[0]);
        this.assertElement(document, "Cars/Hybrid/car[1]", new String[0]);
        this.assertElement(document, "Cars/Sports", new String[0]);
    }

    @Test
    public void shouldParseXmlDocumentWithCDATA() throws Exception {
        String cdata = "\n\n              import mx.events.ValidationResultEvent;\t\t\t\n              private var vResult:ValidationResultEvent;\n\t\t\t\n              // Event handler to validate and format input.\n              private function Format():void {\n              \n                    vResult = numVal.validate();\n\n                    if (vResult.type==ValidationResultEvent.VALID) {\n                        var temp:Number=Number(priceUS.text); \n                        formattedUSPrice.text= usdFormatter.format(temp);\n                    }\n                    \n                    else {\n                       formattedUSPrice.text=\"\";\n                    }\n              }\n        ";
        Node document = this.sequenceAndAssertDocument("docWithCDATA.xml");
        this.assertComment(document, null, 1, "Simple example to demonstrate the CurrencyFormatter.");
        this.assertElement(document, "mx:Application", new String[0]);
        this.assertElement(document, "mx:Application/mx:Script", new String[0]);
        this.assertCdata(document, "mx:Application/mx:Script", cdata);
        this.assertElement(document, "mx:Application/programlisting3", new String[0]);
        this.assertContent(document, "mx:Application/programlisting3", 1, "mixture of text and");
        this.assertCdata(document, "mx:Application/programlisting3", "\n<dependency>entities like &gt; are not replaced in a CDATA\n</dependency>\n");
        this.assertContent(document, "mx:Application/programlisting3", 2, "and some text");
        this.assertComment(document, "mx:Application/programlisting3", 1, "comment in content");
        this.assertContent(document, "mx:Application/programlisting3", 3, "after.");
        this.assertElement(document, "mx:Application/mx:NumberValidator", "id=numVal", "source={priceUS}", "property=text", "allowNegative=true", "domain=real");
    }

    @Test
    public void shouldParseXmlDocumentWithDtd() throws Exception {
        this.sequenceAndAssertDocument("master.xml", "book", "-//OASIS//DTD DocBook XML V4.4//EN", "http://www.oasis-open.org/docbook/xml/4.4/docbookx.dtd");
    }

    @Test
    @FixFor(value={"MODE-2011"})
    public void shouldParseXmlDocumentWithRootNamespace() throws Exception {
        Node document = this.sequenceAndAssertDocument("docWithRootNamespace.xml");
        String generatedPrefix = this.session.getNamespacePrefix("http://maven.apache.org/POM/4.0.0") + ":";
        this.assertElement(document, generatedPrefix + "project", new String[0]);
        this.assertElement(document, generatedPrefix + "project/" + generatedPrefix + "modelVersion", new String[0]);
        this.assertContent(document, generatedPrefix + "project/" + generatedPrefix + "modelVersion", 1, "4.0.0");
        this.assertElement(document, generatedPrefix + "project/" + generatedPrefix + "artifactId", new String[0]);
        this.assertContent(document, generatedPrefix + "project/" + generatedPrefix + "artifactId", 1, "test");
        this.assertElement(document, generatedPrefix + "project/" + generatedPrefix + "packaging", new String[0]);
        this.assertContent(document, generatedPrefix + "project/" + generatedPrefix + "packaging", 1, "pom");
    }

    private void registerDefaultNamespace() throws RepositoryException {
        this.session().getWorkspace().getNamespaceRegistry().registerNamespace("c", "http://default.namespace.com");
    }

    private Node assertCData(Node document, String parentRelativePath, int index, String content) throws RepositoryException {
        return this.assertNode(document, this.pathAtIndex(parentRelativePath, "modexml:cData", index), "modexml:cData", this.nameValuePair("modexml:cDataContent", content));
    }

    private void assertComment(Node document, String parentRelativePath, int index, String expectedValue) throws RepositoryException {
        this.assertNode(document, this.pathAtIndex(parentRelativePath, "modexml:comment", index), "modexml:comment", this.nameValuePair("modexml:commentContent", expectedValue));
    }

    private void assertContent(Node document, String parentRelativePath, int index, String expectedValue) throws RepositoryException {
        this.assertNode(document, this.pathAtIndex(parentRelativePath, "modexml:elementContent", index), "modexml:elementContent", this.nameValuePair("modexml:elementContent", expectedValue));
    }

    private Node sequenceAndAssertDocument(String documentFilename, String name, String publicId, String systemId) throws Exception {
        Node document = this.sequenceAndAssertDocument(documentFilename);
        Assert.assertEquals((Object)name, (Object)document.getProperty("modedtd:name").getString());
        Assert.assertEquals((Object)publicId, (Object)document.getProperty("modedtd:publicId").getString());
        Assert.assertEquals((Object)systemId, (Object)document.getProperty("modedtd:systemId").getString());
        return document;
    }

    private void assertEntity(Node rootNode, int index, String entityName, String value) throws RepositoryException {
        this.assertNode(rootNode, this.pathAtIndex(null, "modedtd:entity", index), "modedtd:entity", this.nameValuePair("modedtd:name", entityName), this.nameValuePair("modedtd:value", value));
    }

    private void assertEntity(Node rootNode, int index, String entityName, String publicId, String systemId) throws RepositoryException {
        if (publicId != null) {
            this.assertNode(rootNode, this.pathAtIndex(null, "modedtd:entity", index), "modedtd:entity", this.nameValuePair("modedtd:name", entityName), this.nameValuePair("modedtd:publicId", publicId), this.nameValuePair("modedtd:systemId", systemId));
        } else {
            this.assertNode(rootNode, this.pathAtIndex(null, "modedtd:entity", index), "modedtd:entity", this.nameValuePair("modedtd:name", entityName), this.nameValuePair("modedtd:systemId", systemId));
        }
    }

    private void assertProcessingInstruction(Node rootNode, int index, String target, String data) throws RepositoryException {
        this.assertNode(rootNode, this.pathAtIndex(null, "modexml:processingInstruction", index), "modexml:processingInstruction", this.nameValuePair("modexml:target", target), this.nameValuePair("modexml:processingInstructionContent", data));
    }

    private void assertCdata(Node rootNode, String parentRelativePath, String value) throws RepositoryException {
        this.assertNode(rootNode, this.pathAtIndex(parentRelativePath, "modexml:cData", 1), "modexml:cData", this.nameValuePair("modexml:cDataContent", value));
    }

    private void assertProperty(Node parentNode, String relativePath, String propertyName, String expectedValue) throws RepositoryException {
        Node expectedNode = parentNode.getNode(relativePath);
        Assert.assertNotNull((Object)expectedNode);
        Assert.assertEquals((Object)expectedValue, (Object)expectedNode.getProperty(propertyName).getValue().getString());
    }

    private String nameValuePair(String name, String value) {
        return name + "=" + value;
    }

    private String pathAtIndex(String parentPath, String nodeName, int index) {
        String childPath = nodeName + "[" + index + "]";
        return parentPath != null ? parentPath + "/" + childPath : childPath;
    }
}

