/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.xsd;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDPatternFacet;
import org.eclipse.xsd.XSDProcessContents;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDRepeatableFacet;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.util.XSDParser;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.SizeMeasuringInputStream;
import org.modeshape.common.util.SizeMeasuringReader;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.sramp.AbstractResolvingReader;
import org.modeshape.sequencer.sramp.SymbolSpace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.InputSource;

@NotThreadSafe
public class XsdReader
extends AbstractResolvingReader {
    public static final SymbolSpace ATTRIBUTE_DECLARATIONS = new SymbolSpace("AttributeDeclarations");
    public static final SymbolSpace ELEMENT_DECLARATION = new SymbolSpace("ElementDeclarations");
    public static final SymbolSpace TYPE_DEFINITIONS = new SymbolSpace("TypeDeclarations");
    public static final SymbolSpace ATTRIBUTE_GROUP_DEFINITIONS = new SymbolSpace("AttributeGroupDeclarations");
    public static final SymbolSpace MODEL_GROUP_DEFINITIONS = new SymbolSpace("ModelGroupDeclarations");
    public static final SymbolSpace IDENTITY_CONSTRAINT_DEFINITIONS = new SymbolSpace("IdentityConstraintDeclarations");
    private static final Logger LOGGER = LoggerFactory.getLogger(XsdReader.class);

    public XsdReader(Sequencer.Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(InputSource source, Node outputNode) throws Exception {
        LOGGER.debug("Processing XSD '{}'", (Object)outputNode);
        Reader reader = null;
        InputStream stream = null;
        try {
            HashMap options = new HashMap();
            XSDParser parser = new XSDParser(options);
            AtomicLong contentSize = new AtomicLong();
            if (source.getCharacterStream() != null) {
                reader = new SizeMeasuringReader(source.getCharacterStream(), contentSize);
                source = new InputSource(reader);
            } else {
                stream = new SizeMeasuringInputStream(source.getByteStream(), contentSize);
                source = new InputSource(stream);
            }
            parser.parse(source);
            String encoding = parser.getEncoding();
            XSDSchema schema = parser.getSchema();
            this.process(schema, encoding, contentSize.get(), outputNode);
            return;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Cannot close reader stream ", (Throwable)e);
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot close reader stream ", (Throwable)e);
                }
            }
        }
    }

    protected void process(XSDSchema schema, String encoding, long contentSize, Node rootNode) throws Exception {
        assert (schema != null);
        LOGGER.debug("Target namespace: '{0}'", (Object)schema.getTargetNamespace());
        rootNode.setProperty("sramp:contentType", "application/xsd");
        if (encoding != null) {
            rootNode.setProperty("sramp:contentEncoding", encoding);
        }
        rootNode.setProperty("sramp:contentSize", contentSize);
        EList annotations = schema.getAnnotations();
        this.processAnnotations((List<XSDAnnotation>)annotations, rootNode);
        this.processNonSchemaAttributes((XSDConcreteComponent)schema, rootNode);
        for (EObject obj : schema.eContents()) {
            if (obj instanceof XSDSimpleTypeDefinition) {
                this.processSimpleTypeDefinition((XSDSimpleTypeDefinition)obj, rootNode);
                continue;
            }
            if (obj instanceof XSDComplexTypeDefinition) {
                this.processComplexTypeDefinition((XSDComplexTypeDefinition)obj, rootNode);
                continue;
            }
            if (obj instanceof XSDElementDeclaration) {
                this.processElementDeclaration((XSDElementDeclaration)obj, rootNode);
                continue;
            }
            if (obj instanceof XSDAttributeDeclaration) {
                this.processAttributeDeclaration((XSDAttributeDeclaration)obj, rootNode, false);
                continue;
            }
            if (obj instanceof XSDImport) {
                this.processImport((XSDImport)obj, rootNode);
                continue;
            }
            if (obj instanceof XSDInclude) {
                this.processInclude((XSDInclude)obj, rootNode);
                continue;
            }
            if (obj instanceof XSDRedefine) {
                this.processRedefine((XSDRedefine)obj, rootNode);
                continue;
            }
            if (obj instanceof XSDAttributeGroupDefinition) {
                this.processAttributeGroupDefinition((XSDAttributeGroupDefinition)obj, rootNode);
                continue;
            }
            if (!(obj instanceof XSDAnnotation)) continue;
        }
        this.resolveReferences();
    }

    protected void processImport(XSDImport xsdImport, Node parentNode) throws RepositoryException {
        LOGGER.debug("Import: '{}' with location '{}' ", (Object)xsdImport.getNamespace(), (Object)xsdImport.getSchemaLocation());
        Node importNode = parentNode.addNode("xs:import", "xs:import");
        importNode.setProperty("xs:namespace", xsdImport.getNamespace());
        importNode.setProperty("xs:schemaLocation", xsdImport.getSchemaLocation());
        this.processNonSchemaAttributes((XSDConcreteComponent)xsdImport, importNode);
    }

    protected void processInclude(XSDInclude xsdInclude, Node parentNode) throws RepositoryException {
        LOGGER.debug("Include: '{}' ", (Object)xsdInclude.getSchemaLocation());
        Node includeNode = parentNode.addNode("xs:include", "xs:include");
        includeNode.setProperty("xs:schemaLocation", xsdInclude.getSchemaLocation());
        this.processNonSchemaAttributes((XSDConcreteComponent)xsdInclude, includeNode);
    }

    protected void processRedefine(XSDRedefine redefine, Node parentNode) throws RepositoryException {
        LOGGER.debug("Include: '{}' ", (Object)redefine.getSchemaLocation());
        Node redefineNode = parentNode.addNode("xs:redefine", "xs:redefine");
        redefineNode.setProperty("xs:schemaLocation", redefine.getSchemaLocation());
        this.processNonSchemaAttributes((XSDConcreteComponent)redefine, redefineNode);
    }

    protected void processSimpleTypeDefinition(XSDSimpleTypeDefinition type, Node node) throws RepositoryException {
        boolean isAnonymous = type.getName() == null;
        String nodeName = isAnonymous ? "xs:simpleType" : type.getName();
        LOGGER.debug("Simple type: '{}' in ns '{}' ", (Object)type.getName(), (Object)type.getTargetNamespace());
        Node typeNode = node.addNode(nodeName, "xs:simpleTypeDefinition");
        typeNode.setProperty("xs:namespace", type.getTargetNamespace());
        if (!isAnonymous) {
            typeNode.setProperty("xs:ncName", type.getName());
            this.registerForSymbolSpace(TYPE_DEFINITIONS, type.getTargetNamespace(), type.getName(), typeNode.getIdentifier());
        }
        this.processTypeFacets(type, typeNode, type.getBaseType());
        this.processNonSchemaAttributes((XSDConcreteComponent)type, typeNode);
    }

    protected void processTypeFacets(XSDSimpleTypeDefinition type, Node typeNode, XSDTypeDefinition baseType) throws RepositoryException {
        if (baseType == null) {
            baseType = type.getBaseType();
        }
        if (baseType == type) {
            baseType = type.getSchema().getSchemaForSchema().resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", "anyType");
        }
        if (baseType != null) {
            typeNode.setProperty("xs:baseTypeName", baseType.getName());
            typeNode.setProperty("xs:baseTypeNamespace", baseType.getTargetNamespace());
            this.setReference(typeNode, "xs:baseType", TYPE_DEFINITIONS, baseType.getTargetNamespace(), baseType.getName());
        }
        this.processFacet((XSDFacet)type.getEffectiveMaxLengthFacet(), typeNode, "xs:maxLength", 3);
        this.processFacet((XSDFacet)type.getMaxLengthFacet(), typeNode, "xs:maxLength", 3);
        this.processFacet((XSDFacet)type.getEffectiveMinLengthFacet(), typeNode, "xs:minLength", 3);
        this.processFacet((XSDFacet)type.getMinLengthFacet(), typeNode, "xs:minLength", 3);
        this.processFacet((XSDFacet)type.getEffectiveMaxFacet(), typeNode, "xs:maxValueExclusive", 3);
        this.processFacet((XSDFacet)type.getMaxExclusiveFacet(), typeNode, "xs:maxValueExclusive", 3);
        this.processFacet((XSDFacet)type.getEffectiveMinFacet(), typeNode, "xs:minValueExclusive", 3);
        this.processFacet((XSDFacet)type.getMinExclusiveFacet(), typeNode, "xs:minValueExclusive", 3);
        this.processFacet((XSDFacet)type.getMaxInclusiveFacet(), typeNode, "xs:maxValueInclusive", 3);
        this.processFacet((XSDFacet)type.getMinInclusiveFacet(), typeNode, "xs:minValueInclusive", 3);
        this.processFacet((XSDFacet)type.getEffectiveTotalDigitsFacet(), typeNode, "xs:totalDigits", 3);
        this.processFacet((XSDFacet)type.getTotalDigitsFacet(), typeNode, "xs:totalDigits", 3);
        this.processFacet((XSDFacet)type.getEffectiveFractionDigitsFacet(), typeNode, "xs:fractionDigits", 3);
        this.processFacet((XSDFacet)type.getFractionDigitsFacet(), typeNode, "xs:fractionDigits", 3);
        this.processFacet((XSDFacet)type.getEffectiveWhiteSpaceFacet(), typeNode, "xs:whitespace", 1);
        this.processFacet((XSDFacet)type.getWhiteSpaceFacet(), typeNode, "xs:whitespace", 1);
        this.processFacet((XSDFacet)type.getEffectivePatternFacet(), typeNode, "xs:pattern", 1);
        EList patternFacets = type.getPatternFacets();
        this.processFacetsList((List)patternFacets, typeNode, "xs:pattern");
        this.processFacet((XSDFacet)type.getEffectiveEnumerationFacet(), typeNode, "xs:enumeratedValues", 1);
        EList enumFacets = type.getEnumerationFacets();
        this.processFacetsList((List)enumFacets, typeNode, "xs:enumeratedValues");
        EList finalFacets2 = type.getFinal();
        this.processEnumerators((List)finalFacets2, typeNode, "xs:final");
        this.processAnnotation(type.getAnnotation(), typeNode);
    }

    protected void processComplexTypeDefinition(XSDComplexTypeDefinition type, Node parentNode) throws RepositoryException {
        XSDTypeDefinition baseType;
        LOGGER.debug("Complex type: '{}' in ns '{}' ", (Object)type.getName(), (Object)type.getTargetNamespace());
        boolean isAnonymous = type.getName() == null;
        String nodeName = isAnonymous ? "xs:complexType" : type.getName();
        Node typeNode = parentNode.addNode(nodeName, "xs:complexTypeDefinition");
        typeNode.setProperty("xs:namespace", type.getTargetNamespace());
        if (!isAnonymous) {
            typeNode.setProperty("xs:ncName", type.getName());
            this.registerForSymbolSpace(TYPE_DEFINITIONS, type.getTargetNamespace(), type.getName(), typeNode.getIdentifier());
        }
        if ((baseType = type.getBaseType()) == type) {
            baseType = type.getSchema().getSchemaForSchema().resolveComplexTypeDefinition("http://www.w3.org/2001/XMLSchema", "anyType");
        }
        if (baseType != null) {
            typeNode.setProperty("xs:baseTypeName", baseType.getName());
            typeNode.setProperty("xs:baseTypeNamespace", baseType.getTargetNamespace());
        }
        typeNode.setProperty("xs:abstract", type.isAbstract());
        typeNode.setProperty("xs:mixed", type.isMixed());
        EList blocks = type.getBlock();
        this.processEnumerators((List)blocks, typeNode, "xs:block");
        EList finalFacets = type.getFinal();
        this.processEnumerators((List)finalFacets, typeNode, "xs:final");
        this.processComplexTypeContent(type.getContent(), typeNode);
        this.processAnnotation(type.getAnnotation(), typeNode);
        this.processNonSchemaAttributes((XSDConcreteComponent)type, typeNode);
    }

    protected Node processElementDeclaration(XSDElementDeclaration decl, Node parentNode) throws RepositoryException {
        Node declarationNode;
        if (decl == null) {
            return null;
        }
        LOGGER.debug("Element declaration: '{}' in ns '{}' ", (Object)decl.getName(), (Object)decl.getTargetNamespace());
        if (decl.getName() != null) {
            declarationNode = parentNode.addNode(decl.getName(), "xs:elementDeclaration");
            declarationNode.setProperty("xs:ncName", decl.getName());
            declarationNode.setProperty("xs:namespace", decl.getTargetNamespace());
        } else {
            assert (decl.isFeatureReference()) : "expected element reference";
            XSDElementDeclaration resolved = decl.getResolvedElementDeclaration();
            declarationNode = parentNode.addNode(resolved.getName(), "xs:elementDeclaration");
            declarationNode.setProperty("xs:refName", resolved.getName());
            declarationNode.setProperty("xs:refNamespace", resolved.getTargetNamespace());
            this.setReference(declarationNode, "xs:ref", ELEMENT_DECLARATION, resolved.getTargetNamespace(), resolved.getName());
        }
        if (decl.isGlobal()) {
            this.registerForSymbolSpace(ELEMENT_DECLARATION, decl.getTargetNamespace(), decl.getName(), declarationNode.getIdentifier());
        }
        declarationNode.setProperty("xs:abstract", decl.isAbstract());
        declarationNode.setProperty("xs:nillable", decl.isNillable());
        XSDTypeDefinition type = decl.getType();
        if (type != null) {
            declarationNode.setProperty("xs:typeName", type.getName());
            declarationNode.setProperty("xs:typeNamespace", type.getTargetNamespace());
            this.setReference(declarationNode, "xs:type", TYPE_DEFINITIONS, type.getTargetNamespace(), type.getName());
        }
        if (decl.getAnonymousTypeDefinition() == type) {
            if (type instanceof XSDComplexTypeDefinition) {
                this.processComplexTypeDefinition((XSDComplexTypeDefinition)type, declarationNode);
            } else if (type instanceof XSDSimpleTypeDefinition) {
                this.processSimpleTypeDefinition((XSDSimpleTypeDefinition)type, declarationNode);
            }
        }
        this.processEnumerator(decl.getForm(), declarationNode, "xs:form");
        EList finals = decl.getLexicalFinal();
        this.processEnumerators((List)finals, declarationNode, "xs:final");
        EList blocks = decl.getBlock();
        this.processEnumerators((List)blocks, declarationNode, "xs:block");
        this.processAnnotation(decl.getAnnotation(), declarationNode);
        this.processNonSchemaAttributes((XSDConcreteComponent)type, declarationNode);
        return declarationNode;
    }

    protected Node processAttributeDeclaration(XSDAttributeDeclaration decl, Node parentNode, boolean isUse) throws RepositoryException {
        XSDTypeDefinition type;
        if (decl == null) {
            return null;
        }
        LOGGER.debug("Attribute declaration: '{0}' in ns '{1}' ", (Object)decl.getName(), (Object)decl.getTargetNamespace());
        Node attributeDeclarationNode = parentNode.addNode(decl.getName(), "xs:attributeDeclaration");
        attributeDeclarationNode.setProperty("xs:ncName", decl.getName());
        attributeDeclarationNode.setProperty("xs:namespace", decl.getTargetNamespace());
        if (decl.isGlobal() && !isUse) {
            this.registerForSymbolSpace(ATTRIBUTE_DECLARATIONS, decl.getTargetNamespace(), decl.getName(), attributeDeclarationNode.getIdentifier());
        }
        if ((type = decl.getType()) != null) {
            attributeDeclarationNode.setProperty("xs:typeName", type.getName());
            attributeDeclarationNode.setProperty("xs:typeNamespace", type.getTargetNamespace());
        }
        this.processAnnotation(decl.getAnnotation(), attributeDeclarationNode);
        this.processNonSchemaAttributes((XSDConcreteComponent)type, attributeDeclarationNode);
        return attributeDeclarationNode;
    }

    protected void processComplexTypeContent(XSDComplexTypeContent content, Node parentNode) throws RepositoryException {
        EList attributeUses;
        EList attributeGroupContents;
        if (content == null) {
            return;
        }
        XSDComplexTypeDefinition owner = (XSDComplexTypeDefinition)content.eContainer();
        if (content instanceof XSDParticle) {
            this.processParticle((XSDParticle)content, parentNode);
        } else if (content instanceof XSDSimpleTypeDefinition) {
            Node contentNode = parentNode.addNode("xs:simpleContent", "xs:simpleContent");
            this.processTypeFacets((XSDSimpleTypeDefinition)content, contentNode, owner.getBaseTypeDefinition());
        }
        XSDDerivationMethod method = owner.getDerivationMethod();
        if (method != null) {
            parentNode.setProperty("xs:method", method.getLiteral());
        }
        if ((attributeGroupContents = owner.getAttributeContents()) != null) {
            for (XSDAttributeGroupContent attributeGroup : attributeGroupContents) {
                this.processAttributeGroupContent(attributeGroup, parentNode);
            }
        }
        if ((attributeUses = owner.getAttributeUses()) != null) {
            for (XSDAttributeUse attributeUse : attributeUses) {
                this.processAttributeUse(attributeUse, parentNode);
            }
        }
        XSDWildcard wildcard = owner.getAttributeWildcard();
        this.processWildcard(wildcard, parentNode);
        this.processNonSchemaAttributes((XSDConcreteComponent)owner, parentNode);
    }

    protected void processParticle(XSDParticle content, Node node) throws RepositoryException {
        if (content == null) {
            return;
        }
        XSDParticleContent particle = content.getContent();
        Node particleNode = null;
        if (particle instanceof XSDModelGroupDefinition) {
            particleNode = this.processModelGroupDefinition((XSDModelGroupDefinition)particle, node);
        } else if (particle instanceof XSDElementDeclaration) {
            particleNode = this.processElementDeclaration((XSDElementDeclaration)particle, node);
        } else if (particle instanceof XSDModelGroup) {
            particleNode = this.processModelGroup((XSDModelGroup)particle, node);
        } else if (particle instanceof XSDWildcard) {
            particleNode = this.processWildcard((XSDWildcard)particle, node);
        }
        if (particleNode != null) {
            long minOccurs = content.getMinOccurs();
            long maxOccurs = content.getMaxOccurs();
            particleNode.setProperty("xs:minOccurs", minOccurs);
            if (maxOccurs >= 0L) {
                particleNode.setProperty("xs:maxOccurs", maxOccurs);
            }
        }
    }

    protected Node processModelGroupDefinition(XSDModelGroupDefinition defn, Node parentNode) throws RepositoryException {
        if (defn == null) {
            return null;
        }
        XSDModelGroup group = defn.getModelGroup();
        this.processNonSchemaAttributes((XSDConcreteComponent)defn, parentNode);
        return this.processModelGroup(group, parentNode);
    }

    protected Node processModelGroup(XSDModelGroup group, Node parentNode) throws RepositoryException {
        if (group == null) {
            return null;
        }
        XSDCompositor compositor = group.getCompositor();
        String primaryTypeName = this.getPrimaryTypeFromCompositor(compositor);
        Node childNode = parentNode.addNode(primaryTypeName, primaryTypeName);
        EList particles = group.getParticles();
        for (XSDParticle particle : particles) {
            this.processParticle(particle, childNode);
        }
        this.processNonSchemaAttributes((XSDConcreteComponent)group, childNode);
        return childNode;
    }

    private String getPrimaryTypeFromCompositor(XSDCompositor compositor) {
        String primaryTypeName = null;
        switch (compositor.getValue()) {
            case 0: {
                primaryTypeName = "xs:all";
                break;
            }
            case 1: {
                primaryTypeName = "xs:choice";
                break;
            }
            case 2: {
                primaryTypeName = "xs:sequence";
                break;
            }
            default: {
                assert (false) : "should not get here";
                break;
            }
        }
        return primaryTypeName;
    }

    protected void processAttributeGroupContent(XSDAttributeGroupContent content, Node parentNode) throws RepositoryException {
        if (content == null) {
            return;
        }
        if (content instanceof XSDAttributeGroupDefinition) {
            this.processAttributeGroupDefinition((XSDAttributeGroupDefinition)content, parentNode);
            return;
        }
        if (content instanceof XSDAttributeUse) {
            this.processAttributeUse((XSDAttributeUse)content, parentNode);
            return;
        }
        assert (false) : "Invalid attribute group content type";
    }

    protected void processAttributeGroupDefinition(XSDAttributeGroupDefinition defn, Node parentNode) throws RepositoryException {
        if (defn == null) {
            return;
        }
        Node attributeGroupNode = null;
        if (defn.isAttributeGroupDefinitionReference()) {
            XSDAttributeGroupDefinition resolved = defn.getResolvedAttributeGroupDefinition();
            LOGGER.debug("Attribute Group definition (ref): '{}' in ns '{}' ", (Object)resolved.getName(), (Object)resolved.getTargetNamespace());
            attributeGroupNode = parentNode.addNode(resolved.getName(), "xs:attributeGroup");
            this.setReference(attributeGroupNode, "xs:ref", ATTRIBUTE_GROUP_DEFINITIONS, resolved.getTargetNamespace(), resolved.getName());
        } else {
            LOGGER.debug("Attribute Group definition: '{}' in ns '{}' ", (Object)defn.getName(), (Object)defn.getTargetNamespace());
            attributeGroupNode = parentNode.addNode(defn.getName(), "xs:attributeGroup");
            this.registerForSymbolSpace(ATTRIBUTE_GROUP_DEFINITIONS, defn.getTargetNamespace(), defn.getName(), attributeGroupNode.getIdentifier());
            attributeGroupNode.setProperty("xs:ncName", defn.getName());
            attributeGroupNode.setProperty("xs:namespace", defn.getTargetNamespace());
            for (Object child : defn.getContents()) {
                if (child instanceof XSDAttributeUse) {
                    this.processAttributeUse((XSDAttributeUse)child, attributeGroupNode);
                    continue;
                }
                if (!(child instanceof XSDWildcard)) continue;
                this.processWildcard((XSDWildcard)child, attributeGroupNode);
            }
        }
        this.processAnnotation(defn.getAnnotation(), attributeGroupNode);
        this.processNonSchemaAttributes((XSDConcreteComponent)defn, attributeGroupNode);
    }

    protected Node processWildcard(XSDWildcard wildcard, Node parentNode) throws RepositoryException {
        if (wildcard == null) {
            return null;
        }
        LOGGER.debug("Any Attribute");
        Node anyAttributeNode = parentNode.addNode("xs:anyAttribute", "xs:anyAttribute");
        EList nsConstraints = wildcard.getNamespaceConstraint();
        if (nsConstraints != null && !nsConstraints.isEmpty()) {
            HashSet<String> values = new HashSet<String>();
            for (String nsConstraint : nsConstraints) {
                if (nsConstraint == null || (nsConstraint = nsConstraint.trim()).length() == 0) continue;
                values.add(nsConstraint);
            }
            if (!values.isEmpty()) {
                anyAttributeNode.setProperty("xs:namespace", values.toArray(new String[values.size()]));
            }
        }
        if (wildcard.getProcessContents() != null) {
            XSDProcessContents processContents = wildcard.getProcessContents();
            anyAttributeNode.setProperty("xs:processContents", processContents.getLiteral());
        }
        this.processAnnotation(wildcard.getAnnotation(), anyAttributeNode);
        this.processNonSchemaAttributes((XSDConcreteComponent)wildcard, anyAttributeNode);
        return anyAttributeNode;
    }

    protected void processAttributeUse(XSDAttributeUse use, Node parentNode) throws RepositoryException {
        Node attributeDeclaration = this.processAttributeDeclaration(use.getAttributeDeclaration(), parentNode, true);
        if (use.getUse() != null) {
            attributeDeclaration.setProperty("xs:use", use.getUse().getLiteral());
        }
        this.processNonSchemaAttributes((XSDConcreteComponent)use, attributeDeclaration);
    }

    protected void processNonSchemaAttributes(XSDConcreteComponent component, Node node) throws RepositoryException {
        if (component == null) {
            return;
        }
        Element element = component.getElement();
        if (element == null) {
            return;
        }
        NamedNodeMap attributes = element.getAttributes();
        if (attributes == null) {
            return;
        }
        int len = attributes.getLength();
        for (int i = 0; i != len; ++i) {
            String namespaceUri;
            org.w3c.dom.Node attribute = attributes.item(i);
            if (attribute.getNodeType() != 2 || "http://www.w3.org/2001/XMLSchema".equals(namespaceUri = attribute.getNamespaceURI())) continue;
            String localName = attribute.getLocalName();
            String value = attribute.getNodeValue();
            if (value == null) continue;
            if (namespaceUri != null) {
                NamespaceRegistry namespaceRegistry = node.getSession().getWorkspace().getNamespaceRegistry();
                String prefix = this.registerNamespace(namespaceRegistry, namespaceUri, attribute.getPrefix());
                String propertyName = prefix + ":" + localName;
                node.setProperty(propertyName, value);
                continue;
            }
            node.setProperty(localName, value);
        }
    }

    protected void processAnnotation(XSDAnnotation annotation, Node node) throws RepositoryException {
        if (annotation == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Object obj : annotation.getUserInformation()) {
            String content;
            Element element = (Element)obj;
            if (!element.getLocalName().equals("documentation") || (content = element.getTextContent()) == null) continue;
            sb.append(content);
        }
        if (sb.length() != 0) {
            String content = sb.toString();
            if ((content = content.trim()).length() != 0) {
                node.setProperty("sramp:description", content);
            }
        }
    }

    protected void processAnnotations(List<XSDAnnotation> annotations, Node parentNode) throws RepositoryException {
        assert (annotations != null);
        StringBuilder sb = new StringBuilder();
        for (XSDAnnotation annotation : annotations) {
            for (Object obj : annotation.getUserInformation()) {
                String content;
                Element element = (Element)obj;
                if (!element.getLocalName().equals("documentation") || (content = element.getTextContent()) == null) continue;
                sb.append(content);
            }
            sb.append(System.getProperty("line.separator"));
        }
        if (sb.length() != 0) {
            String content = sb.toString();
            if ((content = content.trim()).length() != 0) {
                parentNode.setProperty("sramp:description", content);
            }
        }
    }

    protected void processFacet(XSDFacet facet, Node node, String propertyName, int propertyType) throws RepositoryException {
        Set<String> values;
        if (facet == null) {
            return;
        }
        String lexicalValue = facet.getLexicalValue();
        if (lexicalValue != null) {
            Value value = this.context.valueFactory().createValue(facet.getLexicalValue(), propertyType);
            node.setProperty(propertyName, value);
        } else if (facet instanceof XSDRepeatableFacet && !(values = this.getRepeatableFacetValues((XSDRepeatableFacet)facet)).isEmpty()) {
            node.setProperty(propertyName, values.toArray(new String[values.size()]));
        }
    }

    private Set<String> getRepeatableFacetValues(XSDRepeatableFacet facet) {
        EList facetValues = null;
        if (facet instanceof XSDPatternFacet) {
            facetValues = ((XSDPatternFacet)facet).getValue();
        } else if (facet instanceof XSDEnumerationFacet) {
            facetValues = ((XSDEnumerationFacet)facet).getValue();
        }
        HashSet<String> values = new HashSet<String>();
        if (facetValues != null && !facetValues.isEmpty()) {
            for (Object enumValue : facetValues) {
                values.add(enumValue.toString());
            }
        }
        return values;
    }

    protected <Facet extends XSDFacet> void processFacetsList(List<Facet> facets, Node node, String propertyName) throws RepositoryException {
        if (facets == null) {
            return;
        }
        HashSet<String> values = new HashSet<String>();
        for (XSDFacet facet : facets) {
            String lexicalValue = facet.getLexicalValue();
            if (lexicalValue != null) {
                values.add(facet.getLexicalValue());
                continue;
            }
            if (!(facet instanceof XSDRepeatableFacet)) continue;
            values.addAll(this.getRepeatableFacetValues((XSDRepeatableFacet)facet));
        }
        if (!values.isEmpty()) {
            node.setProperty(propertyName, values.toArray(new String[values.size()]));
        }
    }

    protected <Enumerator extends AbstractEnumerator> void processEnumerators(List<Enumerator> enumerators, Node node, String propertyName) throws RepositoryException {
        if (enumerators == null) {
            return;
        }
        HashSet<String> values = new HashSet<String>();
        for (AbstractEnumerator enumValue : enumerators) {
            String value = enumValue.getLiteral();
            if (value == null) continue;
            values.add(value);
        }
        if (!values.isEmpty()) {
            node.setProperty(propertyName, values.toArray(new String[values.size()]));
        }
    }

    protected <Enumerator extends AbstractEnumerator> void processEnumerator(Enumerator enumerator, Node node, String propertyName) throws RepositoryException {
        if (enumerator != null && enumerator.getLiteral() != null) {
            node.setProperty(propertyName, enumerator.getLiteral());
        }
    }
}

