/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.zip;

import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.zip.SequencingOutputTestClass;
import org.modeshape.sequencer.zip.ZipSequencer;

public class ZipSequencerTest {
    private InputStream imageStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.imageStream != null) {
            try {
                this.imageStream.close();
            }
            finally {
                this.imageStream = null;
            }
        }
    }

    protected InputStream getTestZip(String resourcePath) {
        return this.getClass().getResourceAsStream("/" + resourcePath);
    }

    @Test
    public void shouldBeAbleToExtractZip() {
        InputStream is = this.getTestZip("testzip.zip");
        ZipSequencer zs = new ZipSequencer();
        SequencingOutputTestClass seqtest = new SequencingOutputTestClass();
        StreamSequencerContext context = (StreamSequencerContext)Mockito.mock(StreamSequencerContext.class);
        Mockito.stub((Object)context.getValueFactories()).toReturn((Object)new ExecutionContext().getValueFactories());
        zs.sequence(is, (SequencerOutput)seqtest, context);
        Assert.assertThat((Object)seqtest.properties.get(3).getPath(), (Matcher)Is.is((Object)"zip:content/test subfolder/test2.txt/jcr:content"));
    }
}

