/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.ogg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.gagravarr.ogg.CRCUtils;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggPacketReader;
import org.gagravarr.ogg.OggPage;

public class TestBasicRead
extends TestCase {
    private InputStream getTestFile() throws IOException {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/testVORBIS.ogg");
    }

    public void testOpen() throws IOException {
        OggFile ogg = new OggFile(this.getTestFile());
        OggPacketReader r = ogg.getPacketReader();
        r.getNextPacket();
        try {
            ogg.getPacketWriter();
            TestBasicRead.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testPages() throws IOException {
        InputStream inp = this.getTestFile();
        inp.read();
        inp.read();
        inp.read();
        inp.read();
        OggPage page = new OggPage(inp);
        TestBasicRead.assertEquals((boolean)false, (boolean)page.isContinuation());
        TestBasicRead.assertEquals((boolean)false, (boolean)page.hasContinuation());
        TestBasicRead.assertEquals((long)0L, (long)page.getGranulePosition());
        TestBasicRead.assertEquals((int)74691676, (int)page.getSid());
        TestBasicRead.assertEquals((int)0, (int)page.getSequenceNumber());
        TestBasicRead.assertEquals((boolean)true, (boolean)page.isChecksumValid());
        TestBasicRead.assertEquals((int)30, (int)page.getDataSize());
        TestBasicRead.assertEquals((int)58, (int)page.getPageSize());
        TestBasicRead.assertEquals((int)1, (int)page.getNumLVs());
        OggPage.OggPacketIterator i = page.getPacketIterator();
        TestBasicRead.assertEquals((boolean)true, (boolean)i.hasNext());
        OggPacket p = (OggPacket)i.next();
        TestBasicRead.assertEquals((int)30, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)true, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((int)74691676, (int)p.getSid());
        TestBasicRead.assertEquals((boolean)false, (boolean)i.hasNext());
        inp.read();
        inp.read();
        inp.read();
        inp.read();
        page = new OggPage(inp);
        TestBasicRead.assertEquals((boolean)false, (boolean)page.isContinuation());
        TestBasicRead.assertEquals((boolean)false, (boolean)page.hasContinuation());
        TestBasicRead.assertEquals((long)0L, (long)page.getGranulePosition());
        TestBasicRead.assertEquals((int)74691676, (int)page.getSid());
        TestBasicRead.assertEquals((int)1, (int)page.getSequenceNumber());
        TestBasicRead.assertEquals((boolean)true, (boolean)page.isChecksumValid());
        TestBasicRead.assertEquals((int)15, (int)page.getNumLVs());
        i = page.getPacketIterator();
        TestBasicRead.assertEquals((boolean)true, (boolean)i.hasNext());
        p = (OggPacket)i.next();
        TestBasicRead.assertEquals((int)219, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((int)74691676, (int)p.getSid());
        TestBasicRead.assertEquals((boolean)true, (boolean)i.hasNext());
        p = (OggPacket)i.next();
        TestBasicRead.assertEquals((int)3484, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((int)74691676, (int)p.getSid());
        TestBasicRead.assertEquals((boolean)false, (boolean)i.hasNext());
        inp.read();
        inp.read();
        inp.read();
        inp.read();
        page = new OggPage(inp);
        TestBasicRead.assertEquals((boolean)false, (boolean)page.isContinuation());
        TestBasicRead.assertEquals((boolean)false, (boolean)page.hasContinuation());
        TestBasicRead.assertEquals((long)960L, (long)page.getGranulePosition());
        TestBasicRead.assertEquals((int)74691676, (int)page.getSid());
        TestBasicRead.assertEquals((int)2, (int)page.getSequenceNumber());
        TestBasicRead.assertEquals((boolean)true, (boolean)page.isChecksumValid());
        TestBasicRead.assertEquals((int)9, (int)page.getNumLVs());
        i = page.getPacketIterator();
        TestBasicRead.assertEquals((boolean)true, (boolean)i.hasNext());
        p = (OggPacket)i.next();
        TestBasicRead.assertEquals((int)35, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((boolean)true, (boolean)i.hasNext());
        p = (OggPacket)i.next();
        TestBasicRead.assertEquals((int)28, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((boolean)true, (boolean)i.hasNext());
        p = (OggPacket)i.next();
        TestBasicRead.assertEquals((int)30, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((boolean)true, (boolean)i.hasNext());
        p = (OggPacket)i.next();
        TestBasicRead.assertEquals((int)52, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((boolean)true, (boolean)i.hasNext());
        p = (OggPacket)i.next();
        TestBasicRead.assertEquals((int)51, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((boolean)true, (boolean)i.hasNext());
        p = (OggPacket)i.next();
        TestBasicRead.assertEquals((int)69, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((boolean)true, (boolean)i.hasNext());
        p = (OggPacket)i.next();
        TestBasicRead.assertEquals((int)59, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((boolean)true, (boolean)i.hasNext());
        p = (OggPacket)i.next();
        TestBasicRead.assertEquals((int)40, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((boolean)true, (boolean)i.hasNext());
        p = (OggPacket)i.next();
        TestBasicRead.assertEquals((int)38, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)true, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)i.hasNext());
        TestBasicRead.assertEquals((int)-1, (int)inp.read());
    }

    public void testPackets() throws IOException {
        OggFile ogg = new OggFile(this.getTestFile());
        OggPacketReader r = ogg.getPacketReader();
        OggPacket p = r.getNextPacket();
        TestBasicRead.assertEquals((int)30, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)true, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((int)74691676, (int)p.getSid());
        TestBasicRead.assertEquals((long)0L, (long)p.getGranulePosition());
        TestBasicRead.assertEquals((int)0, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestBasicRead.assertEquals((int)219, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((int)74691676, (int)p.getSid());
        TestBasicRead.assertEquals((long)0L, (long)p.getGranulePosition());
        TestBasicRead.assertEquals((int)1, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestBasicRead.assertEquals((int)3484, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((int)74691676, (int)p.getSid());
        TestBasicRead.assertEquals((long)0L, (long)p.getGranulePosition());
        TestBasicRead.assertEquals((int)1, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestBasicRead.assertEquals((int)35, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((int)74691676, (int)p.getSid());
        TestBasicRead.assertEquals((long)960L, (long)p.getGranulePosition());
        TestBasicRead.assertEquals((int)2, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestBasicRead.assertEquals((int)28, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((int)74691676, (int)p.getSid());
        TestBasicRead.assertEquals((long)960L, (long)p.getGranulePosition());
        TestBasicRead.assertEquals((int)2, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestBasicRead.assertEquals((int)30, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((int)74691676, (int)p.getSid());
        TestBasicRead.assertEquals((long)960L, (long)p.getGranulePosition());
        TestBasicRead.assertEquals((int)2, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestBasicRead.assertEquals((int)52, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((int)74691676, (int)p.getSid());
        TestBasicRead.assertEquals((long)960L, (long)p.getGranulePosition());
        TestBasicRead.assertEquals((int)2, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestBasicRead.assertEquals((int)51, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((int)74691676, (int)p.getSid());
        TestBasicRead.assertEquals((long)960L, (long)p.getGranulePosition());
        TestBasicRead.assertEquals((int)2, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestBasicRead.assertEquals((int)69, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((int)74691676, (int)p.getSid());
        TestBasicRead.assertEquals((long)960L, (long)p.getGranulePosition());
        TestBasicRead.assertEquals((int)2, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestBasicRead.assertEquals((int)59, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((int)74691676, (int)p.getSid());
        TestBasicRead.assertEquals((long)960L, (long)p.getGranulePosition());
        TestBasicRead.assertEquals((int)2, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestBasicRead.assertEquals((int)40, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((int)74691676, (int)p.getSid());
        TestBasicRead.assertEquals((long)960L, (long)p.getGranulePosition());
        TestBasicRead.assertEquals((int)2, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestBasicRead.assertEquals((int)38, (int)p.getData().length);
        TestBasicRead.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicRead.assertEquals((boolean)true, (boolean)p.isEndOfStream());
        TestBasicRead.assertEquals((int)74691676, (int)p.getSid());
        TestBasicRead.assertEquals((long)960L, (long)p.getGranulePosition());
        TestBasicRead.assertEquals((int)2, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestBasicRead.assertEquals(null, (Object)p);
    }

    public void testCRC() throws IOException {
        InputStream inp = this.getTestFile();
        inp.read();
        inp.read();
        inp.read();
        inp.read();
        OggPage page = new OggPage(inp);
        TestBasicRead.assertEquals((long)1776334944L, (long)page.getChecksum());
        TestBasicRead.assertTrue((boolean)page.isChecksumValid());
        byte[] header = page.getHeader();
        TestBasicRead.assertEquals((int)28, (int)header.length);
        OggPacket p = (OggPacket)page.getPacketIterator().next();
        page = new OggPage(74691676, 0);
        page.addPacket(p, 0);
        TestBasicRead.assertEquals((long)0L, (long)page.getChecksum());
        TestBasicRead.assertTrue((boolean)page.isChecksumValid());
        byte[] header2 = page.getHeader();
        TestBasicRead.assertEquals((int)28, (int)header2.length);
        for (int i = 0; i < 28; ++i) {
            TestBasicRead.assertEquals((byte)header[i], (byte)header2[i]);
        }
        int crc = CRCUtils.getCRC((byte[])header);
        crc = CRCUtils.getCRC((byte[])page.getData(), (int)crc);
        TestBasicRead.assertEquals((int)1776334944, (int)crc);
        crc = CRCUtils.getCRC((byte[])header);
        crc = CRCUtils.getCRC((byte[])page.getData(), (int)crc);
        TestBasicRead.assertEquals((int)1776334944, (int)crc);
        CRCUtils.getCRC((byte[])new byte[]{1, 2, 3, 4});
        page.writeHeader((OutputStream)new ByteArrayOutputStream());
        TestBasicRead.assertEquals((long)1776334944L, (long)page.getChecksum());
        TestBasicRead.assertTrue((boolean)page.isChecksumValid());
    }
}

