/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.mvcc.repeatable_read;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.api.mvcc.LockTestBase;
import org.infinispan.transaction.tm.DummyTransactionManager;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.mvcc.repeatable_read.RepeatableReadLockTest")
public class RepeatableReadLockTest
extends LockTestBase {
    public RepeatableReadLockTest() {
        this.repeatableRead = true;
    }

    public void testRepeatableReadWithRemove() throws Exception {
        LockTestBase.LockTestBaseTL tl = (LockTestBase.LockTestBaseTL)this.threadLocal.get();
        Cache<String, String> cache = tl.cache;
        TransactionManager tm = tl.tm;
        cache.put((Object)"k", (Object)"v");
        tm.begin();
        assert (cache.get((Object)"k") != null);
        Transaction reader = tm.suspend();
        tm.begin();
        assert (cache.remove((Object)"k") != null);
        assert (cache.get((Object)"k") == null);
        tm.commit();
        assert (cache.get((Object)"k") == null);
        tm.resume(reader);
        assert (cache.get((Object)"k") != null);
        assert ("v".equals(cache.get((Object)"k")));
        tm.commit();
        assert (cache.get((Object)"k") == null);
        this.assertNoLocks();
    }

    public void testRepeatableReadWithEvict() throws Exception {
        LockTestBase.LockTestBaseTL tl = (LockTestBase.LockTestBaseTL)this.threadLocal.get();
        Cache<String, String> cache = tl.cache;
        TransactionManager tm = tl.tm;
        cache.put((Object)"k", (Object)"v");
        tm.begin();
        assert (cache.get((Object)"k") != null);
        Transaction reader = tm.suspend();
        tm.begin();
        cache.evict((Object)"k");
        assert (cache.get((Object)"k") == null);
        tm.commit();
        assert (cache.get((Object)"k") == null);
        tm.resume(reader);
        assert (cache.get((Object)"k") != null);
        assert ("v".equals(cache.get((Object)"k")));
        tm.commit();
        assert (cache.get((Object)"k") == null);
        this.assertNoLocks();
    }

    public void testRepeatableReadWithNull() throws Exception {
        LockTestBase.LockTestBaseTL tl = (LockTestBase.LockTestBaseTL)this.threadLocal.get();
        Cache<String, String> cache = tl.cache;
        TransactionManager tm = tl.tm;
        assert (cache.get((Object)"k") == null);
        tm.begin();
        assert (cache.get((Object)"k") == null);
        Transaction reader = tm.suspend();
        tm.begin();
        cache.put((Object)"k", (Object)"v");
        assert (cache.get((Object)"k") != null);
        assert ("v".equals(cache.get((Object)"k")));
        tm.commit();
        assert (cache.get((Object)"k") != null);
        assert ("v".equals(cache.get((Object)"k")));
        tm.resume(reader);
        Object o = cache.get((Object)"k");
        assert (o == null) : "found value " + o;
        tm.commit();
        assert (cache.get((Object)"k") != null);
        assert ("v".equals(cache.get((Object)"k")));
        this.assertNoLocks();
    }

    public void testRepeatableReadWithNullRemoval() throws Exception {
        LockTestBase.LockTestBaseTL tl = (LockTestBase.LockTestBaseTL)this.threadLocal.get();
        Cache<String, String> cache = tl.cache;
        TransactionManager tm = tl.tm;
        tm.begin();
        cache.get((Object)"a");
        Transaction tx = tm.suspend();
        cache.put((Object)"a", (Object)"v2");
        assert (((String)cache.get((Object)"a")).equals("v2"));
        tm.resume(tx);
        assert (cache.get((Object)"a") == null) : "expected null but received " + (String)cache.get((Object)"a");
        cache.remove((Object)"a");
        tm.commit();
        assert (cache.get((Object)"a") == null) : "expected null but received " + (String)cache.get((Object)"a");
    }

    @Override
    public void testLocksOnPutKeyVal() throws Exception {
        LockTestBase.LockTestBaseTL tl = (LockTestBase.LockTestBaseTL)this.threadLocal.get();
        Cache<String, String> cache = tl.cache;
        DummyTransactionManager tm = (DummyTransactionManager)tl.tm;
        tm.begin();
        cache.put((Object)"k", (Object)"v");
        tm.getTransaction().runPrepare();
        this.assertLocked("k");
        tm.getTransaction().runCommitTx();
        tm.suspend();
        this.assertNoLocks();
        tm.begin();
        assert (((String)cache.get((Object)"k")).equals("v"));
        this.assertNotLocked("k");
        tm.commit();
        this.assertNoLocks();
        tm.begin();
        cache.remove((Object)"k");
        tm.getTransaction().runPrepare();
        this.assertLocked("k");
        tm.getTransaction().runCommitTx();
        this.assertNoLocks();
    }
}

