/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.mvcc.repeatable_read;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.api.mvcc.LockAssert;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.mvcc.repeatable_read.WriteSkewTest")
public class WriteSkewTest
extends AbstractInfinispanTest {
    private static final Log log = LogFactory.getLog(WriteSkewTest.class);
    protected TransactionManager tm;
    protected LockManager lockManager;
    protected InvocationContextContainer icc;
    protected EmbeddedCacheManager cacheManager;
    protected Cache cache;

    @BeforeTest
    public void setUp() {
        Configuration c = new Configuration();
        c.fluent().transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        c.setLockAcquisitionTimeout(200L);
        c.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cacheManager = TestCacheManagerFactory.createCacheManager(c);
    }

    @AfterTest
    public void tearDown() {
        TestingUtil.killCacheManagers(this.cacheManager);
        this.cacheManager = null;
        this.cache = null;
        this.lockManager = null;
        this.tm = null;
        this.icc = null;
    }

    private void postStart() {
        this.lockManager = (LockManager)TestingUtil.extractComponentRegistry(this.cache).getComponent(LockManager.class);
        this.icc = (InvocationContextContainer)TestingUtil.extractComponentRegistry(this.cache).getComponent(InvocationContextContainer.class);
        this.tm = (TransactionManager)TestingUtil.extractComponentRegistry(this.cache).getComponent(TransactionManager.class);
    }

    protected void assertNoLocks() {
        LockAssert.assertNoLocks(this.lockManager, this.icc);
    }

    public void testDontCheckWriteSkew() throws Exception {
        Configuration noWriteSkewCheck = new Configuration();
        noWriteSkewCheck.setWriteSkewCheck(false);
        this.cacheManager.defineConfiguration("noWriteSkewCheck", noWriteSkewCheck);
        this.cache = this.cacheManager.getCache("noWriteSkewCheck");
        this.postStart();
        this.doTest(true);
    }

    public void testCheckWriteSkew() throws Exception {
        Configuration writeSkewCheck = new Configuration();
        writeSkewCheck.setWriteSkewCheck(true);
        this.cacheManager.defineConfiguration("writeSkewCheck", writeSkewCheck);
        this.cache = this.cacheManager.getCache("writeSkewCheck");
        this.postStart();
        this.doTest(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteSkewWithOnlyPut() throws Exception {
        Configuration writeSkewCheck = new Configuration();
        writeSkewCheck.setWriteSkewCheck(true);
        this.cacheManager.defineConfiguration("writeSkewCheckWithOnlyPut", writeSkewCheck);
        this.cache = this.cacheManager.getCache("writeSkewCheckWithOnlyPut");
        this.postStart();
        this.tm.begin();
        try {
            this.cache.put((Object)"k", (Object)"init");
        }
        catch (Exception e) {
            this.tm.setRollbackOnly();
            throw e;
        }
        finally {
            if (this.tm.getStatus() == 0) {
                this.tm.commit();
            } else {
                this.tm.rollback();
            }
        }
        int nbWriters = 10;
        CyclicBarrier barrier = new CyclicBarrier(nbWriters + 1);
        ArrayList<Future> futures = new ArrayList<Future>(nbWriters);
        ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){
            volatile int i = 0;

            @Override
            public Thread newThread(Runnable r) {
                int ii = this.i++;
                return new Thread(r, "EntryWriter-" + ii + ", WriteSkewTest");
            }
        });
        try {
            for (int i = 0; i < nbWriters; ++i) {
                log.debug((Object)"Schedule execution");
                Future future = executorService.submit(new EntryWriter(barrier));
                futures.add(future);
            }
            barrier.await();
            barrier.await();
            log.debug((Object)"All threads finished, let's shutdown the executor and check whether any exceptions were reported");
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private void doTest(final boolean allowWriteSkew) throws Exception {
        this.cache.put((Object)"k", (Object)"v");
        final HashSet w1exceptions = new HashSet();
        final HashSet w2exceptions = new HashSet();
        final CountDownLatch w1Signal = new CountDownLatch(1);
        final CountDownLatch w2Signal = new CountDownLatch(1);
        final CountDownLatch threadSignal = new CountDownLatch(2);
        Thread w1 = new Thread("Writer-1, WriteSkewTest"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean didCoundDown = false;
                try {
                    WriteSkewTest.this.tm.begin();
                    assert ("v".equals(WriteSkewTest.this.cache.get((Object)"k")));
                    threadSignal.countDown();
                    didCoundDown = true;
                    w1Signal.await();
                    WriteSkewTest.this.cache.put((Object)"k", (Object)"v2");
                    WriteSkewTest.this.tm.commit();
                }
                catch (Exception e) {
                    w1exceptions.add(e);
                }
                finally {
                    if (!didCoundDown) {
                        threadSignal.countDown();
                    }
                }
            }
        };
        Thread w2 = new Thread("Writer-2, WriteSkewTest"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean didCoundDown = false;
                try {
                    WriteSkewTest.this.tm.begin();
                    assert ("v".equals(WriteSkewTest.this.cache.get((Object)"k")));
                    threadSignal.countDown();
                    didCoundDown = true;
                    w2Signal.await();
                    WriteSkewTest.this.cache.put((Object)"k", (Object)"v3");
                    WriteSkewTest.this.tm.commit();
                }
                catch (Exception e) {
                    w2exceptions.add(e);
                    if (!allowWriteSkew) {
                        try {
                            WriteSkewTest.this.tm.rollback();
                        }
                        catch (SystemException systemException) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    if (!didCoundDown) {
                        threadSignal.countDown();
                    }
                }
            }
        };
        w1.start();
        w2.start();
        threadSignal.await();
        w1Signal.countDown();
        w1.join();
        w2Signal.countDown();
        w2.join();
        if (allowWriteSkew) {
            this.throwExceptions(w1exceptions, w2exceptions);
            assert (w2exceptions.isEmpty());
            assert (w1exceptions.isEmpty());
            assert ("v3".equals(this.cache.get((Object)"k"))) : "W2 should have overwritten W1's work!";
            this.assertNoLocks();
        } else {
            HashSet combined = new HashSet(w1exceptions);
            combined.addAll(w2exceptions);
            assert (!combined.isEmpty());
            assert (combined.size() == 1);
            assert (combined.iterator().next() instanceof CacheException);
        }
    }

    private void throwExceptions(Collection<Exception> ... exceptions) throws Exception {
        for (Collection<Exception> ce : exceptions) {
            Iterator<Exception> i$ = ce.iterator();
            if (!i$.hasNext()) continue;
            Exception e = i$.next();
            throw e;
        }
    }

    protected class EntryWriter
    implements Callable<Void> {
        private final CyclicBarrier barrier;

        public EntryWriter(CyclicBarrier barrier) {
            this.barrier = barrier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                log.debug((Object)"Wait for all executions paths to be ready to perform calls");
                this.barrier.await();
                WriteSkewTest.this.tm.begin();
                try {
                    WriteSkewTest.this.cache.put((Object)"k", (Object)"_lockthisplease_");
                }
                catch (Exception e) {
                    log.error((Object)"Unexpected", (Throwable)e);
                    WriteSkewTest.this.tm.setRollbackOnly();
                    throw e;
                }
                finally {
                    if (WriteSkewTest.this.tm.getStatus() == 0) {
                        WriteSkewTest.this.tm.commit();
                    } else {
                        WriteSkewTest.this.tm.rollback();
                    }
                }
                Void void_ = null;
                return void_;
            }
            finally {
                log.debug((Object)"Wait for all execution paths to finish");
                this.barrier.await();
            }
        }
    }
}

