/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="config.ProgrammaticNameSetConfig")
public class ProgrammaticNameSetConfig
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager(this.getDefaultStandaloneConfig(true));
    }

    public void testGetNotDefaultCache() {
        Configuration configurationOverride = new Configuration();
        configurationOverride.fluent().mode(Configuration.CacheMode.LOCAL);
        String aName = "aName";
        Configuration configuration = this.cacheManager.defineConfiguration(aName, configurationOverride);
        Cache c = this.cacheManager.getCache(aName);
        Assert.assertEquals((String)c.getConfiguration().getName(), (String)aName);
        Assert.assertEquals((String)configuration.getName(), (String)aName);
    }

    public void testGetNameForDefaultCache() {
        String name = this.cacheManager.getCache().getConfiguration().getName();
        Assert.assertEquals((String)name, (String)"___defaultcache");
    }

    public void getNameForUndefinedCache() {
        Configuration configuration = this.cacheManager.getCache("undefinedCache").getConfiguration();
        Assert.assertEquals((String)configuration.getName(), (String)"undefinedCache");
    }
}

