/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config.parsing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.config.parsing.ConfigFilesConvertor;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.decorators.AsyncStoreConfig;
import org.infinispan.loaders.decorators.SingletonStoreConfig;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.marshall.VersionAwareMarshaller;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="config.parsing.Jbc2InfinispanTransformerTest")
public class Jbc2InfinispanTransformerTest
extends AbstractInfinispanTest {
    public static final String XSLT_FILE = "xslt/jbc3x2infinispan4x.xslt";
    private static final String BASE_DIR = "configs/jbosscache3x";
    ConfigFilesConvertor convertor = new ConfigFilesConvertor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAllFile() throws Exception {
        ClassLoader existingCl = Thread.currentThread().getContextClassLoader();
        try {
            TestClassLoader delegatingCl = new TestClassLoader(existingCl);
            Thread.currentThread().setContextClassLoader(delegatingCl);
            String fileName = this.getFileName("all.xml");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.convertor.parse(fileName, (OutputStream)baos, XSLT_FILE, Thread.currentThread().getContextClassLoader());
            DefaultCacheManager ecm = new DefaultCacheManager((InputStream)new ByteArrayInputStream(baos.toByteArray()), false);
            Configuration defaultConfig = ecm.getDefaultConfiguration();
            GlobalConfiguration globalConfig = ecm.getGlobalConfiguration();
            assert (defaultConfig.getIsolationLevel().equals((Object)IsolationLevel.READ_COMMITTED));
            assert (defaultConfig.getLockAcquisitionTimeout() == 234000L);
            assert (defaultConfig.getConcurrencyLevel() == 510);
            assert (defaultConfig.getTransactionManagerLookup().getClass().getName().equals("org.infinispan.transaction.lookup.GenericTransactionManagerLookup"));
            assert (!defaultConfig.isSyncCommitPhase());
            assert (defaultConfig.isSyncRollbackPhase());
            assert (defaultConfig.isExposeJmxStatistics());
            assert (globalConfig.getShutdownHookBehavior().equals((Object)GlobalConfiguration.ShutdownHookBehavior.DONT_REGISTER));
            assert (globalConfig.getAsyncListenerExecutorProperties().get("maxThreads").equals("123"));
            assert (globalConfig.getAsyncListenerExecutorProperties().get("queueSize").equals("1020000"));
            assert (!defaultConfig.isInvocationBatchingEnabled());
            assert (globalConfig.getMarshallerClass().equals(VersionAwareMarshaller.class.getName()));
            assert (defaultConfig.isStoreAsBinary());
            assert (globalConfig.getClusterName().equals("JBossCache-cluster"));
            assert (defaultConfig.getCacheMode().equals((Object)Configuration.CacheMode.INVALIDATION_SYNC));
            assert (defaultConfig.getStateRetrievalTimeout() == 2120000L);
            assert (defaultConfig.getSyncReplTimeout() == 22220000L);
            assert (defaultConfig.getEvictionStrategy().equals((Object)EvictionStrategy.LRU));
            assert (defaultConfig.getEvictionMaxEntries() == 5001);
            assert (defaultConfig.getExpirationMaxIdle() == 1001L) : "Received " + defaultConfig.getExpirationLifespan();
            assert (defaultConfig.getExpirationWakeUpInterval() == 50015L);
            ConcurrentMap configurationOverrides = (ConcurrentMap)TestingUtil.extractField(ecm, "configurationOverrides");
            Configuration regionOne = (Configuration)configurationOverrides.get("/org/jboss/data1");
            assert (regionOne != null);
            assert (regionOne.getEvictionStrategy().equals((Object)EvictionStrategy.LRU));
            assert (regionOne.getExpirationMaxIdle() == 2002L);
            assert (regionOne.getExpirationWakeUpInterval() == 50015L);
            Configuration regionTwo = (Configuration)configurationOverrides.get("/org/jboss/data2");
            assert (regionTwo != null);
            assert (regionTwo.getEvictionStrategy().equals((Object)EvictionStrategy.FIFO));
            assert (regionTwo.getEvictionMaxEntries() == 3003);
            assert (regionTwo.getExpirationWakeUpInterval() == 50015L);
            CacheLoaderManagerConfig loaderManagerConfig = defaultConfig.getCacheLoaderManagerConfig();
            assert (loaderManagerConfig.isPassivation().booleanValue());
            assert (loaderManagerConfig.isShared().booleanValue());
            assert (loaderManagerConfig.getCacheLoaderConfigs().size() == 1);
            CacheStoreConfig config = (CacheStoreConfig)loaderManagerConfig.getCacheLoaderConfigs().get(0);
            assert (config.getCacheLoaderClassName().equals("org.infinispan.loaders.file.FileCacheStore"));
            AsyncStoreConfig asyncStoreConfig = config.getAsyncStoreConfig();
            assert (asyncStoreConfig != null);
            assert (asyncStoreConfig.isEnabled().booleanValue());
            assert (config.isFetchPersistentState().booleanValue());
            assert (config.isIgnoreModifications().booleanValue());
            assert (config.isPurgeOnStartup().booleanValue());
            SingletonStoreConfig singletonStoreConfig = config.getSingletonStoreConfig();
            assert (singletonStoreConfig != null);
            assert (singletonStoreConfig.isSingletonStoreEnabled().booleanValue());
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCanTransformExistingFiles() throws Exception {
        ClassLoader existingCl = Thread.currentThread().getContextClassLoader();
        try {
            String[] testFiles;
            TestClassLoader delegatingCl = new TestClassLoader(existingCl);
            Thread.currentThread().setContextClassLoader(delegatingCl);
            for (String name : testFiles = new String[]{"buddy-replication.xml", "cacheloader-enabled.xml", "eviction-enabled.xml", "external-jgroups-file.xml", "invalidation-async.xml", "total-replication.xml"}) {
                String fileName = this.getFileName(name);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.convertor.parse(fileName, (OutputStream)baos, XSLT_FILE, Thread.currentThread().getContextClassLoader());
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingCl);
        }
    }

    private String getFileName(String s) {
        return BASE_DIR + File.separator + s;
    }

    public static class TestClassLoader
    extends ClassLoader {
        private ClassLoader existing;

        TestClassLoader(ClassLoader existing) {
            super(existing);
            this.existing = existing;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (name.equals("org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStore")) {
                return DummyInMemoryCacheStore.class;
            }
            return this.existing.loadClass(name);
        }
    }
}

