/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.DistributionManagerImpl;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashHelper;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.distribution.ch.UnionConsistentHash;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.IsolationLevel;

public abstract class BaseDistFunctionalTest
extends MultipleCacheManagersTest {
    protected String cacheName;
    protected int INIT_CLUSTER_SIZE = 4;
    protected Cache<Object, String> c1 = null;
    protected Cache<Object, String> c2 = null;
    protected Cache<Object, String> c3 = null;
    protected Cache<Object, String> c4 = null;
    protected Configuration configuration;
    protected List<Cache<Object, String>> caches;
    protected List<Address> cacheAddresses;
    protected boolean sync = true;
    protected boolean tx = false;
    protected boolean testRetVals = true;
    protected boolean l1CacheEnabled = true;
    protected boolean l1OnRehash = false;
    protected int l1Threshold = 5;
    protected boolean performRehashing = false;
    protected boolean batchingEnabled = false;
    protected int numOwners = 2;
    protected int lockTimeout = 45;
    protected int numVirtualNodes = 1;
    protected boolean groupsEnabled = false;
    protected List<Grouper<?>> groupers;
    protected LockingMode lockingMode;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.cacheName = "dist";
        this.configuration = this.buildConfiguration();
        this.caches = this.createClusteredCaches(this.INIT_CLUSTER_SIZE, this.cacheName, this.configuration, new TransportFlags().withFD(true));
        this.reorderBasedOnCHPositions();
        if (this.INIT_CLUSTER_SIZE > 0) {
            this.c1 = this.caches.get(0);
        }
        if (this.INIT_CLUSTER_SIZE > 1) {
            this.c2 = this.caches.get(1);
        }
        if (this.INIT_CLUSTER_SIZE > 2) {
            this.c3 = this.caches.get(2);
        }
        if (this.INIT_CLUSTER_SIZE > 3) {
            this.c4 = this.caches.get(3);
        }
        this.cacheAddresses = new ArrayList<Address>(this.INIT_CLUSTER_SIZE);
        for (Cache<Object, String> cache : this.caches) {
            EmbeddedCacheManager cacheManager = cache.getCacheManager();
            this.cacheAddresses.add(cacheManager.getAddress());
        }
    }

    protected Configuration buildConfiguration() {
        Configuration configuration = BaseDistFunctionalTest.getDefaultClusteredConfig(this.sync ? Configuration.CacheMode.DIST_SYNC : Configuration.CacheMode.DIST_ASYNC, this.tx);
        configuration.setRehashEnabled(this.performRehashing);
        if (this.lockingMode != null) {
            configuration.fluent().transaction().lockingMode(this.lockingMode);
        }
        configuration.setNumOwners(this.numOwners);
        if (!this.testRetVals) {
            configuration.setUnsafeUnreliableReturnValues(true);
            configuration.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        }
        configuration.setInvocationBatchingEnabled(this.batchingEnabled);
        configuration.setSyncReplTimeout(60L, TimeUnit.SECONDS);
        configuration.setLockAcquisitionTimeout((long)this.lockTimeout, TimeUnit.SECONDS);
        configuration.setL1CacheEnabled(this.l1CacheEnabled);
        configuration.fluent().clustering().hash().numVirtualNodes(Integer.valueOf(this.numVirtualNodes));
        if (this.groupsEnabled) {
            configuration.fluent().hash().groups().enabled(Boolean.valueOf(true));
            configuration.fluent().hash().groups().groupers(this.groupers);
        }
        if (this.l1CacheEnabled) {
            configuration.setL1OnRehash(this.l1OnRehash);
        }
        if (this.l1CacheEnabled) {
            configuration.setL1InvalidationThreshold(this.l1Threshold);
        }
        return configuration;
    }

    protected static ConsistentHash createNewConsistentHash(Collection<Address> servers) {
        try {
            Configuration c = new Configuration();
            c.setConsistentHashClass(DefaultConsistentHash.class.getName());
            return ConsistentHashHelper.createConsistentHash((Configuration)c, servers);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void reorderBasedOnCHPositions() {
        assert (this.caches.size() == this.INIT_CLUSTER_SIZE);
        this.waitForClusterToForm(this.cacheName);
        Cache<Object, String> seed = this.caches.get(0);
        ConsistentHash ch = this.getNonUnionConsistentHash(seed, TimeUnit.SECONDS.toMillis(480L));
        ArrayList<Cache<Object, String>> reordered = new ArrayList<Cache<Object, String>>();
        block0: for (Address a : ch.getCaches()) {
            for (Cache<Object, String> c : this.caches) {
                EmbeddedCacheManager cacheManager = c.getCacheManager();
                if (!a.equals(cacheManager.getAddress())) continue;
                reordered.add(c);
                continue block0;
            }
        }
        assert (reordered.size() == this.INIT_CLUSTER_SIZE) : "Reordering caches lost some caches: started with " + this.caches + ", ended with " + reordered;
        this.caches = reordered;
    }

    protected void waitForJoinTasksToComplete(long timeout, Cache ... joiners) {
        long giveupTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < giveupTime) {
            boolean allOK = true;
            for (Cache c : joiners) {
                DistributionManagerImpl dmi = (DistributionManagerImpl)this.getDistributionManager(c);
                allOK &= dmi.isJoinComplete();
            }
            if (allOK) {
                return;
            }
            TestingUtil.sleepThread(100L);
        }
        throw new RuntimeException("Some caches have not finished rehashing after " + Util.prettyPrintTime((long)timeout));
    }

    protected void initAndTest() {
        for (Cache<Object, String> c : this.caches) {
            assert (c.isEmpty());
        }
        this.c1.put((Object)"k1", (Object)"value");
        this.asyncWait("k1", PutKeyValueCommand.class, new Cache[0]);
        this.assertOnAllCachesAndOwnership("k1", "value");
    }

    protected Address addressOf(Cache<?, ?> cache) {
        return DistributionTestHelper.addressOf(cache);
    }

    protected Cache<Object, String> getFirstNonOwner(String key) {
        return this.getNonOwners(key)[0];
    }

    protected Cache<Object, String> getFirstOwner(String key) {
        return this.getOwners(key)[0];
    }

    protected Cache<Object, String> getSecondNonOwner(String key) {
        return this.getNonOwners(key)[1];
    }

    protected void assertOnAllCachesAndOwnership(Object key, String value) {
        this.assertOwnershipAndNonOwnership(key, this.l1CacheEnabled);
        this.assertOnAllCaches(key, value);
    }

    protected void assertRemovedOnAllCaches(Object key) {
        this.assertOnAllCaches(key, null);
    }

    protected void assertOnAllCaches(Object key, String value) {
        for (Cache<Object, String> c : this.caches) {
            Object realVal = c.get(key);
            if (value == null ? !$assertionsDisabled && realVal != null : !$assertionsDisabled && !value.equals(realVal)) {
                throw new AssertionError((Object)("Expecting [" + key + "] to equal [" + value + "] on cache [" + this.addressOf(c) + "] but was [" + realVal + "]"));
            }
        }
        TestingUtil.sleepThread(1000L);
    }

    protected void assertOwnershipAndNonOwnership(Object key, boolean allowL1) {
        for (Cache<Object, String> c : this.caches) {
            DataContainer dc = c.getAdvancedCache().getDataContainer();
            InternalCacheEntry ice = dc.get(key);
            if (this.isOwner(c, key)) {
                assert (ice != null) : "Fail on owner cache " + this.addressOf(c) + ": dc.get(" + key + ") returned null!";
                assert (ice instanceof ImmortalCacheEntry) : "Fail on owner cache " + this.addressOf(c) + ": dc.get(" + key + ") returned " + this.safeType(ice);
                continue;
            }
            if (allowL1) {
                assert (ice == null || ice instanceof MortalCacheEntry) : "Fail on non-owner cache " + this.addressOf(c) + ": dc.get(" + key + ") returned " + this.safeType(ice);
                continue;
            }
            assert (ice == null) : "Fail on non-owner cache " + this.addressOf(c) + ": dc.get(" + key + ") returned " + ice + "!";
        }
    }

    protected int locateJoiner(Address joinerAddress) {
        for (Cache<Object, String> c : this.caches) {
            ConsistentHash dch = this.getNonUnionConsistentHash(c, TimeUnit.SECONDS.toMillis(480L));
            int i = 0;
            for (Address a : dch.getCaches()) {
                if (a.equals(joinerAddress)) {
                    return i;
                }
                ++i;
            }
        }
        throw new RuntimeException("Cannot locate joiner! Joiner is [" + joinerAddress + "]");
    }

    protected String safeType(Object o) {
        return DistributionTestHelper.safeType(o);
    }

    protected void assertIsInL1(Cache<?, ?> cache, Object key) {
        DistributionTestHelper.assertIsInL1(cache, key);
    }

    protected void assertIsNotInL1(Cache<?, ?> cache, Object key) {
        DistributionTestHelper.assertIsNotInL1(cache, key);
    }

    protected void assertIsInContainerImmortal(Cache<?, ?> cache, Object key) {
        DistributionTestHelper.assertIsInContainerImmortal(cache, key);
    }

    protected void assertIsInL1OrNull(Cache<?, ?> cache, Object key) {
        DistributionTestHelper.assertIsInL1OrNull(cache, key);
    }

    protected boolean isOwner(Cache<?, ?> c, Object key) {
        return DistributionTestHelper.isOwner(c, key);
    }

    protected boolean isFirstOwner(Cache<?, ?> c, Object key) {
        return DistributionTestHelper.isFirstOwner(c, key);
    }

    protected Cache<Object, String>[] getOwners(Object key) {
        return this.getOwners(key, 2);
    }

    protected Cache<Object, String>[] getOwners(Object key, int expectedNumberOwners) {
        Cache[] owners = new Cache[expectedNumberOwners];
        int i = 0;
        for (Cache<Object, String> c : this.caches) {
            if (!this.isOwner(c, key)) continue;
            owners[i++] = c;
        }
        for (Cache c : owners) {
            assert (c != null) : "Have not found enough owners for key [" + key + "]";
        }
        return owners;
    }

    protected Cache<Object, String>[] getNonOwnersExcludingSelf(Object key, Address self) {
        Cache<Object, String>[] nonOwners = this.getNonOwners(key);
        boolean selfInArray = false;
        for (Cache<Object, String> c : nonOwners) {
            if (!this.addressOf(c).equals(self)) continue;
            selfInArray = true;
            break;
        }
        if (selfInArray) {
            Cache[] nonOwnersExclSelf = new Cache[nonOwners.length - 1];
            int i = 0;
            for (Cache<Object, String> c : nonOwners) {
                if (this.addressOf(c).equals(self)) continue;
                nonOwnersExclSelf[i++] = c;
            }
            return nonOwnersExclSelf;
        }
        return nonOwners;
    }

    protected Cache<Object, String>[] getNonOwners(Object key) {
        return this.getNonOwners(key, 2);
    }

    protected Cache<Object, String>[] getNonOwners(Object key, int expectedNumberNonOwners) {
        Cache[] nonOwners = new Cache[expectedNumberNonOwners];
        int i = 0;
        for (Cache<Object, String> c : this.caches) {
            if (this.isOwner(c, key)) continue;
            nonOwners[i++] = c;
        }
        return nonOwners;
    }

    protected List<Address> residentAddresses(Object key) {
        DistributionManager dm = (DistributionManager)this.c1.getAdvancedCache().getComponentRegistry().getComponent(DistributionManager.class);
        return dm.locate(key);
    }

    protected DistributionManager getDistributionManager(Cache<?, ?> c) {
        return (DistributionManager)c.getAdvancedCache().getComponentRegistry().getComponent(DistributionManager.class);
    }

    protected ConsistentHash getConsistentHash(Cache<?, ?> c) {
        return this.getDistributionManager(c).getConsistentHash();
    }

    protected ConsistentHash getNonUnionConsistentHash(Cache<?, ?> c, long timeout) {
        long expTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < expTime) {
            ConsistentHash ch = this.getDistributionManager(c).getConsistentHash();
            if (!(ch instanceof UnionConsistentHash)) {
                return ch;
            }
            TestingUtil.sleepThread(100L);
        }
        throw new RuntimeException("Timed out waiting for a non-UnionConsistentHash to be present on cache [" + this.addressOf(c) + "]");
    }

    protected void asyncWait(Object key, Class<? extends VisitableCommand> command, Cache<?, ?> ... caches) {
    }

    protected void assertProperConsistentHashOnAllCaches() {
        for (Cache<Object, String> c : this.caches) {
            DistributionManager dm = this.getDistributionManager(c);
            assert (!(dm.getConsistentHash() instanceof UnionConsistentHash));
        }
    }

    protected TransactionManager getTransactionManager(Cache<?, ?> cache) {
        return TestingUtil.getTransactionManager(cache);
    }
}

