/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.TestException;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.UnknownCacheStartTest", enabled=false)
public class UnknownCacheStartTest
extends AbstractInfinispanTest {
    Configuration configuration;
    EmbeddedCacheManager cm1;
    EmbeddedCacheManager cm2;

    @BeforeTest
    public void setUp() {
        this.configuration = AbstractCacheTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC);
    }

    @AfterTest
    public void tearDown() {
        TestingUtil.killCacheManagers(this.cm1, this.cm2);
    }

    @Test(expectedExceptions={CacheException.class, TestException.class}, timeOut=60000L, enabled=false)
    public void testStartingUnknownCaches() throws Throwable {
        try {
            this.cm1 = TestCacheManagerFactory.createCacheManager(this.configuration);
            this.cm1.defineConfiguration("new_1", this.configuration);
            Cache c1 = this.cm1.getCache();
            Cache c1_new = this.cm1.getCache("new_1");
            c1.put((Object)"k", (Object)"v");
            c1_new.put((Object)"k", (Object)"v");
            assert ("v".equals(c1.get((Object)"k")));
            assert ("v".equals(c1_new.get((Object)"k")));
            this.cm2 = TestCacheManagerFactory.createCacheManager(this.configuration);
            this.cm2.defineConfiguration("new_2", this.configuration);
            Cache c2 = this.cm2.getCache();
            Cache c2_new = this.cm2.getCache("new_AND_DEFINITELY_UNKNOWN_cache_2");
            c2.put((Object)"k", (Object)"v");
            c2_new.put((Object)"k", (Object)"v");
            assert ("v".equals(c2.get((Object)"k")));
            assert ("v".equals(c2_new.get((Object)"k")));
            TestingUtil.blockUntilViewsReceived(60000L, false, c2, c2_new);
            TestingUtil.waitForRehashToComplete(c2, c2_new);
            assert (false) : "Should have thrown an exception!";
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }
}

