/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.distribution.ch.AbstractWheelConsistentHash;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="distribution.rehash.ConsistencyStressTest", enabled=false)
public class ConsistencyStressTest
extends MultipleCacheManagersTest {
    private static final int NUM_NODES = 10;
    private static final int WORKERS_PER_NODE = 2;
    private static final int NUM_ITERATIONS = 5000;
    private static final boolean IGNORE_TX_FAILURES = true;
    private static final Log log = LogFactory.getLog(ConsistencyStressTest.class);

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = new Configuration();
        c.setIsolationLevel(IsolationLevel.READ_COMMITTED);
        c.setLockAcquisitionTimeout(60000L);
        c.setUseLockStriping(false);
        c.setCacheMode(Configuration.CacheMode.DIST_SYNC);
        c.setL1CacheEnabled(false);
        c.setSyncReplTimeout(30000L);
        c.setUseEagerLocking(true);
        c.setEagerLockSingleNode(true);
        c.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        c.setSyncCommitPhase(true);
        c.setSyncRollbackPhase(true);
        GlobalConfiguration gc = GlobalConfiguration.getClusteredDefault();
        gc.setDistributedSyncTimeout(60000L);
        LinkedList<EmbeddedCacheManager> cacheManagers = new LinkedList<EmbeddedCacheManager>();
        for (int i = 0; i < 10; ++i) {
            cacheManagers.add(TestCacheManagerFactory.createCacheManager(gc, c));
        }
        this.registerCacheManager((CacheContainer[])cacheManagers.toArray(new EmbeddedCacheManager[10]));
    }

    /*
     * WARNING - void declaration
     */
    public void testConsistency() throws Throwable, InterruptedException {
        void var5_10;
        ExecutorService executorService = Executors.newFixedThreadPool(20, new ThreadFactory(){
            int i = 0;

            @Override
            public synchronized Thread newThread(Runnable r) {
                return new Thread(r, "Worker-" + this.i++);
            }
        });
        HashSet<Future<Void>> futures = new HashSet<Future<Void>>(20);
        HashSet keysToIgnore = new HashSet();
        for (int i = 0; i < 10; ++i) {
            Cache cache = this.cache(i);
            for (int j = 0; j < 2; ++j) {
                Future<Void> f = executorService.submit(new Stressor(cache, i, j, keysToIgnore));
                futures.add(f);
                TestingUtil.sleepRandom(500);
            }
        }
        log.info((Object)"Waiting for stressors to finish");
        for (Future future : futures) {
            future.get();
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager)this.cacheManagers.get(0));
        HashMap cacheMap = new HashMap();
        boolean bl = true;
        while (var5_10 < 10) {
            Cache c = this.cache((int)var5_10);
            cacheMap.put(this.address(c), c);
            ++var5_10;
        }
        Thread.sleep(25000L);
        TestingUtil.blockUntilViewsReceived(60000, false, cacheMap.values());
        TestingUtil.waitForRehashToComplete(cacheMap.values());
        AbstractWheelConsistentHash abstractWheelConsistentHash = (AbstractWheelConsistentHash)this.cache(1).getAdvancedCache().getDistributionManager().getConsistentHash();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 5000; ++k) {
                    String key = ConsistencyStressTest.keyFor(i, j, k);
                    if (keysToIgnore.contains(key)) {
                        log.infof("Skipping test on failing key %s", (Object)key);
                        continue;
                    }
                    List owners = abstractWheelConsistentHash.locate((Object)key, 2);
                    for (Map.Entry e : cacheMap.entrySet()) {
                        try {
                            if (!owners.contains(e.getKey())) continue;
                            DistributionTestHelper.assertIsInContainerImmortal((Cache)e.getValue(), key);
                        }
                        catch (Throwable th) {
                            log.fatalf("Key %s (hash %s) should be on owners %s according to %s", new Object[]{key, abstractWheelConsistentHash.getNormalizedHash((Object)key), owners, abstractWheelConsistentHash});
                            throw th;
                        }
                    }
                }
            }
        }
        executorService.shutdownNow();
    }

    private static String keyFor(int nodeId, int workerId, int iterationId) {
        return String.format("__%s_%s_%s__", nodeId, workerId, iterationId);
    }

    private static class Stressor
    implements Callable<Void> {
        private final Cache<String, String> cache;
        private final TransactionManager tm;
        private final int cacheId;
        private final int workerId;
        private final Set<String> keysToIgnore;

        private Stressor(Cache<String, String> cache, int cacheId, int workerId, Set<String> keysToIgnore) {
            this.cache = cache;
            this.tm = TestingUtil.getTransactionManager(cache);
            this.cacheId = cacheId;
            this.workerId = workerId;
            this.keysToIgnore = keysToIgnore;
        }

        @Override
        public Void call() {
            for (int iterationId = 0; iterationId < 5000; ++iterationId) {
                if (iterationId % 500 == 0) {
                    log.infof("  >> Stressor %s Worker %s Iteration %s", (Object)this.cacheId, (Object)this.workerId, (Object)iterationId);
                }
                boolean txError = false;
                Throwable exception = null;
                String key = ConsistencyStressTest.keyFor(this.cacheId, this.workerId, iterationId);
                try {
                    this.tm.begin();
                    this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).put((Object)key, (Object)"value");
                    this.tm.commit();
                }
                catch (HeuristicRollbackException e) {
                    txError = true;
                    exception = e;
                }
                catch (RollbackException e) {
                    txError = true;
                    exception = e;
                }
                catch (SystemException e) {
                    txError = true;
                    exception = e;
                }
                catch (HeuristicMixedException e) {
                    txError = true;
                    exception = e;
                }
                catch (NotSupportedException e) {
                    txError = true;
                    exception = e;
                }
                catch (TimeoutException e) {
                    txError = true;
                    exception = e;
                }
                if (!txError) continue;
                try {
                    this.tm.rollback();
                }
                catch (Exception exc) {
                    log.error((Object)"  >> Rollback failed");
                }
                this.keysToIgnore.add(key);
                log.errorf("  >> Saw a %s when trying to process key %s", (Object)exception.getClass().getSimpleName(), (Object)key);
            }
            return null;
        }
    }
}

