/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.jgroups.protocols.DISCARD;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.RehashAfterPartitionMergeTest")
public class RehashAfterPartitionMergeTest
extends MultipleCacheManagersTest {
    Cache<Object, Object> c1;
    Cache<Object, Object> c2;
    List<Cache<Object, Object>> caches;
    DISCARD d1;
    DISCARD d2;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.caches = this.createClusteredCaches(2, "test", RehashAfterPartitionMergeTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC), new TransportFlags().withFD(true).withMerge(true));
        this.c1 = this.caches.get(0);
        this.c2 = this.caches.get(1);
        this.d1 = TestingUtil.getDiscardForCache(this.c1);
        this.d2 = TestingUtil.getDiscardForCache(this.c2);
    }

    public void testCachePartition() {
        this.c1.put((Object)"1", (Object)"value");
        this.c2.put((Object)"2", (Object)"value");
        for (Cache<Object, Object> c : this.caches) {
            assert ("value".equals(c.get((Object)"1")));
            assert ("value".equals(c.get((Object)"2")));
            assert (this.manager(c).getMembers().size() == 2);
        }
        this.d1.setDiscardAll(true);
        this.d2.setDiscardAll(true);
        TestingUtil.blockUntilViewsChanged(60000L, 1, this.c1, this.c2);
        for (Cache<Object, Object> c : this.caches) {
            assert (this.manager(c).getMembers().size() == 1);
        }
        this.c1.put((Object)"3", (Object)"value");
        this.c2.put((Object)"4", (Object)"value");
        assert ("value".equals(this.c1.get((Object)"3")));
        assert (null == this.c2.get((Object)"3"));
        assert ("value".equals(this.c2.get((Object)"4")));
        assert (null == this.c1.get((Object)"4"));
        this.d1.setDiscardAll(false);
        this.d2.setDiscardAll(false);
        TestingUtil.blockUntilViewsChanged(45000L, 2, this.c1, this.c2);
        TestingUtil.waitForRehashToComplete(this.c1, this.c2);
        this.c1.put((Object)"5", (Object)"value");
        this.c2.put((Object)"6", (Object)"value");
        for (Cache<Object, Object> c : this.caches) {
            assert ("value".equals(c.get((Object)"5")));
            assert ("value".equals(c.get((Object)"6")));
            assert (this.manager(c).getMembers().size() == 2);
        }
    }
}

