/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.topologyaware;

import org.infinispan.config.GlobalConfiguration;
import org.infinispan.distribution.DistSyncFuncTest;
import org.infinispan.distribution.ch.TopologyAwareConsistentHash;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.TopologyAwareChFunctionalTest")
public class TopologyAwareChFunctionalTest
extends DistSyncFuncTest {
    @Override
    protected EmbeddedCacheManager addClusterEnabledCacheManager(TransportFlags flags) {
        String machine;
        String rack;
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(flags);
        int index = this.cacheManagers.size();
        switch (index) {
            case 0: {
                rack = "r0";
                machine = "m0";
                break;
            }
            case 1: {
                rack = "r0";
                machine = "m1";
                break;
            }
            case 2: {
                rack = "r1";
                machine = "m0";
                break;
            }
            case 3: {
                rack = "r2";
                machine = "m0";
                break;
            }
            default: {
                throw new RuntimeException("Bad!");
            }
        }
        GlobalConfiguration globalConfiguration = cm.getGlobalConfiguration();
        globalConfiguration.setRackId(rack);
        globalConfiguration.setMachineId(machine);
        this.cacheManagers.add(cm);
        return cm;
    }

    public void testHashesInitiated() {
        TopologyAwareConsistentHash hash = (TopologyAwareConsistentHash)this.advancedCache(0, this.cacheName).getDistributionManager().getConsistentHash();
        this.containsAllHashes(hash);
        this.containsAllHashes((TopologyAwareConsistentHash)this.advancedCache(1, this.cacheName).getDistributionManager().getConsistentHash());
        this.containsAllHashes((TopologyAwareConsistentHash)this.advancedCache(2, this.cacheName).getDistributionManager().getConsistentHash());
        this.containsAllHashes((TopologyAwareConsistentHash)this.advancedCache(3, this.cacheName).getDistributionManager().getConsistentHash());
    }

    private void containsAllHashes(TopologyAwareConsistentHash ch) {
        assert (ch.getCaches().contains(this.address(0)));
        assert (ch.getCaches().contains(this.address(1)));
        assert (ch.getCaches().contains(this.address(2)));
        assert (ch.getCaches().contains(this.address(3)));
    }
}

