/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.virtualnodes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.infinispan.config.Configuration;
import org.infinispan.distribution.TestAddress;
import org.infinispan.distribution.ch.ConsistentHashHelper;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="distribution.VNodesDefaultConsistentHashTest", enabled=true)
public class VNodesDefaultConsistentHashTest
extends AbstractInfinispanTest {
    public DefaultConsistentHash createConsistentHash(List<Address> servers, int numVirtualNodes) {
        Configuration c = new Configuration().fluent().hash().consistentHashClass(DefaultConsistentHash.class).numVirtualNodes(Integer.valueOf(numVirtualNodes)).build();
        return (DefaultConsistentHash)ConsistentHashHelper.createConsistentHash((Configuration)c, servers);
    }

    public void testEveryNumOwners() {
        int[] numVirtualNodesList;
        for (int numVirtualNodes : numVirtualNodesList = new int[]{2, 10, 100}) {
            for (int nodesCount = 1; nodesCount < 10; ++nodesCount) {
                ArrayList<Address> servers = new ArrayList<Address>(nodesCount);
                for (int i = 0; i < nodesCount; ++i) {
                    servers.add(new TestAddress(i * 1000));
                }
                DefaultConsistentHash ch = this.createConsistentHash(servers, numVirtualNodes);
                ArrayList sortedServers = new ArrayList(ch.getCaches());
                for (int numOwners = 1; numOwners < nodesCount; ++numOwners) {
                    for (int i = 0; i < nodesCount; ++i) {
                        List owners = ch.locate(sortedServers.get(i), numOwners);
                        Assert.assertEquals((int)owners.size(), (int)numOwners);
                        Assert.assertEquals(owners.get(0), sortedServers.get(i));
                        Assert.assertEquals((int)new HashSet(owners).size(), (int)numOwners);
                    }
                }
                for (int i = 0; i < nodesCount; ++i) {
                    List owners = ch.locate(sortedServers.get(i), nodesCount + 1);
                    Assert.assertEquals(new HashSet(owners), servers);
                }
            }
        }
    }
}

