/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.infinispan.interceptors.ActivationInterceptor;
import org.infinispan.interceptors.CacheMgmtInterceptor;
import org.infinispan.interceptors.CallInterceptor;
import org.infinispan.interceptors.DistCacheStoreInterceptor;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.InvalidationInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="interceptors.InterceptorChainTest")
public class InterceptorChainTest {
    private static final Log log = LogFactory.getLog(InterceptorChainTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentAddRemove() throws Exception {
        InterceptorChain ic = new InterceptorChain((CommandInterceptor)new CallInterceptor());
        ic.addInterceptor((CommandInterceptor)new ActivationInterceptor(), 1);
        CyclicBarrier barrier = new CyclicBarrier(4);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(2);
        ExecutorService executorService = Executors.newFixedThreadPool(3);
        try {
            futures.add(executorService.submit(new InterceptorChainUpdater(ic, barrier, (CommandInterceptor)new CacheMgmtInterceptor())));
            futures.add(executorService.submit(new InterceptorChainUpdater(ic, barrier, (CommandInterceptor)new DistCacheStoreInterceptor())));
            futures.add(executorService.submit(new InterceptorChainUpdater(ic, barrier, (CommandInterceptor)new InvalidationInterceptor())));
            barrier.await();
            barrier.await();
            log.debug((Object)"All threads finished, let's shutdown the executor and check whether any exceptions were reported");
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executorService.shutdownNow();
        }
        assert (ic.containsInterceptorType(CallInterceptor.class));
        assert (ic.containsInterceptorType(ActivationInterceptor.class));
        assert (ic.containsInterceptorType(CacheMgmtInterceptor.class));
        assert (ic.containsInterceptorType(DistCacheStoreInterceptor.class));
        assert (ic.containsInterceptorType(InvalidationInterceptor.class));
        assert (ic.asList().size() == 5) : "Resulting interceptor chain was actually " + ic.asList();
    }

    private static class InterceptorChainUpdater
    implements Callable<Void> {
        private final InterceptorChain ic;
        private final CyclicBarrier barrier;
        private final CommandInterceptor commandToExcercise;

        InterceptorChainUpdater(InterceptorChain ic, CyclicBarrier barrier, CommandInterceptor commandToExcercise) {
            this.ic = ic;
            this.barrier = barrier;
            this.commandToExcercise = commandToExcercise;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            Class<?> commandClass = this.commandToExcercise.getClass();
            try {
                log.debug((Object)"Wait for all executions paths to be ready to perform calls");
                this.barrier.await();
                for (int i = 0; i < 2000; ++i) {
                    this.ic.removeInterceptor(commandClass);
                    this.ic.addInterceptor(this.commandToExcercise, 1);
                }
                Void void_ = null;
                return void_;
            }
            finally {
                log.debug((Object)"Wait for all execution paths to finish");
                this.barrier.await();
            }
        }
    }
}

