/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.lang.reflect.Method;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.Cache;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.ActivationAndPassivationInterceptorMBeanTest")
public class ActivationAndPassivationInterceptorMBeanTest
extends SingleCacheManagerTest {
    Cache cache;
    MBeanServer threadMBeanServer;
    ObjectName activationInterceptorObjName;
    ObjectName passivationInterceptorObjName;
    CacheStore cacheStore;
    private static final String JMX_DOMAIN = ActivationAndPassivationInterceptorMBeanTest.class.getSimpleName();

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getNonClusteredDefault();
        globalConfiguration.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        globalConfiguration.setJmxDomain(JMX_DOMAIN);
        globalConfiguration.setExposeGlobalJmxStatistics(true);
        this.cacheManager = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(globalConfiguration);
        DummyInMemoryCacheStore.Cfg cfg = new DummyInMemoryCacheStore.Cfg();
        CacheLoaderManagerConfig clManagerConfig = new CacheLoaderManagerConfig();
        clManagerConfig.setPassivation(Boolean.valueOf(true));
        clManagerConfig.addCacheLoaderConfig((CacheLoaderConfig)cfg);
        Configuration configuration = ActivationAndPassivationInterceptorMBeanTest.getDefaultClusteredConfig(Configuration.CacheMode.LOCAL);
        configuration.setExposeJmxStatistics(true);
        configuration.setCacheLoaderManagerConfig(clManagerConfig);
        this.cacheManager.defineConfiguration("test", configuration);
        this.cache = this.cacheManager.getCache("test");
        this.activationInterceptorObjName = TestingUtil.getCacheObjectName(JMX_DOMAIN, "test(local)", "Activation");
        this.passivationInterceptorObjName = TestingUtil.getCacheObjectName(JMX_DOMAIN, "test(local)", "Passivation");
        this.threadMBeanServer = PerThreadMBeanServerLookup.getThreadMBeanServer();
        this.cacheStore = TestingUtil.extractComponent(this.cache, CacheLoaderManager.class).getCacheStore();
        return this.cacheManager;
    }

    @AfterMethod
    public void resetStats() throws Exception {
        this.threadMBeanServer.invoke(this.activationInterceptorObjName, "resetStatistics", new Object[0], new String[0]);
    }

    public void testDisableStatistics() throws Exception {
        this.threadMBeanServer.setAttribute(this.activationInterceptorObjName, new Attribute("StatisticsEnabled", Boolean.FALSE));
        assert (this.threadMBeanServer.getAttribute(this.activationInterceptorObjName, "Activations").toString().equals("N/A"));
        this.threadMBeanServer.setAttribute(this.activationInterceptorObjName, new Attribute("StatisticsEnabled", Boolean.TRUE));
    }

    public void testActivationOnGet(Method m) throws Exception {
        this.assertActivationCount(0);
        assert (this.cache.get((Object)TestingUtil.k(m)) == null);
        this.assertActivationCount(0);
        this.cacheStore.store(TestInternalCacheEntryFactory.create(TestingUtil.k(m), TestingUtil.v(m)));
        assert (this.cacheStore.containsKey((Object)TestingUtil.k(m)));
        assert (this.cache.get((Object)TestingUtil.k(m)).equals(TestingUtil.v(m)));
        this.assertActivationCount(1);
        assert (!this.cacheStore.containsKey((Object)TestingUtil.k(m)));
    }

    public void testActivationOnPut(Method m) throws Exception {
        this.assertActivationCount(0);
        assert (this.cache.get((Object)TestingUtil.k(m)) == null);
        this.assertActivationCount(0);
        this.cacheStore.store(TestInternalCacheEntryFactory.create(TestingUtil.k(m), TestingUtil.v(m)));
        assert (this.cacheStore.containsKey((Object)TestingUtil.k(m)));
        this.cache.put((Object)TestingUtil.k(m), (Object)TestingUtil.v(m, 2));
        assert (this.cache.get((Object)TestingUtil.k(m)).equals(TestingUtil.v(m, 2)));
        this.assertActivationCount(1);
        assert (!this.cacheStore.containsKey((Object)TestingUtil.k(m))) : "this should only be persisted on evict";
    }

    public void testActivationOnRemove(Method m) throws Exception {
        this.assertActivationCount(0);
        assert (this.cache.get((Object)TestingUtil.k(m)) == null);
        this.assertActivationCount(0);
        this.cacheStore.store(TestInternalCacheEntryFactory.create(TestingUtil.k(m), TestingUtil.v(m)));
        assert (this.cacheStore.containsKey((Object)TestingUtil.k(m)));
        assert (this.cache.remove((Object)TestingUtil.k(m)).equals(TestingUtil.v(m)));
        this.assertActivationCount(1);
        assert (!this.cacheStore.containsKey((Object)TestingUtil.k(m)));
    }

    public void testActivationOnReplace(Method m) throws Exception {
        this.assertActivationCount(0);
        assert (this.cache.get((Object)TestingUtil.k(m)) == null);
        this.assertActivationCount(0);
        this.cacheStore.store(TestInternalCacheEntryFactory.create(TestingUtil.k(m), TestingUtil.v(m)));
        assert (this.cacheStore.containsKey((Object)TestingUtil.k(m)));
        assert (this.cache.replace((Object)TestingUtil.k(m), (Object)TestingUtil.v(m, 2)).equals(TestingUtil.v(m)));
        this.assertActivationCount(1);
        assert (!this.cacheStore.containsKey((Object)TestingUtil.k(m)));
    }

    public void testActivationOnPutMap(Method m) throws Exception {
        this.assertActivationCount(0);
        assert (this.cache.get((Object)TestingUtil.k(m)) == null);
        this.assertActivationCount(0);
        this.cacheStore.store(TestInternalCacheEntryFactory.create(TestingUtil.k(m), TestingUtil.v(m)));
        assert (this.cacheStore.containsKey((Object)TestingUtil.k(m)));
        HashMap<String, String> toAdd = new HashMap<String, String>();
        toAdd.put(TestingUtil.k(m), TestingUtil.v(m, 2));
        this.cache.putAll(toAdd);
        this.assertActivationCount(1);
        assert (this.cache.get((Object)TestingUtil.k(m)).equals(TestingUtil.v(m, 2)));
        assert (!this.cacheStore.containsKey((Object)TestingUtil.k(m)));
    }

    public void testPassivationOnEvict(Method m) throws Exception {
        this.assertPassivationCount(0);
        this.cache.put((Object)TestingUtil.k(m), (Object)TestingUtil.v(m));
        this.cache.put((Object)TestingUtil.k(m, 2), (Object)TestingUtil.v(m, 2));
        this.cache.evict((Object)TestingUtil.k(m));
        this.assertPassivationCount(1);
        this.cache.evict((Object)TestingUtil.k(m, 2));
        this.assertPassivationCount(2);
        this.cache.evict((Object)"not_existing_key");
        this.assertPassivationCount(2);
    }

    private void assertActivationCount(int activationCount) throws Exception {
        assert (Integer.valueOf(this.threadMBeanServer.getAttribute(this.activationInterceptorObjName, "Activations").toString()).equals(activationCount));
    }

    private void assertPassivationCount(int activationCount) throws Exception {
        Object passivations = this.threadMBeanServer.getAttribute(this.passivationInterceptorObjName, "Passivations");
        AssertJUnit.assertEquals((int)activationCount, (int)Integer.valueOf(passivations.toString()));
    }
}

