/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.decorators;

import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.decorators.SingletonStore;
import org.infinispan.loaders.decorators.SingletonStoreConfig;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.ViewChangeListener;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.decorators.SingletonStoreTest", enabled=false, description="See ISPN-1123")
public class SingletonStoreTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(SingletonStoreTest.class);
    private static final AtomicInteger storeCounter = new AtomicInteger(0);
    private EmbeddedCacheManager cm0;
    private EmbeddedCacheManager cm1;
    private EmbeddedCacheManager cm2;

    public SingletonStoreTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected void createCacheManagers() {
        this.cm0 = this.addClusterEnabledCacheManager();
        this.cm1 = this.addClusterEnabledCacheManager();
        this.cm2 = this.addClusterEnabledCacheManager();
        Configuration conf = SingletonStoreTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC);
        DummyInMemoryCacheStore.Cfg cfg = new DummyInMemoryCacheStore.Cfg();
        cfg.setStoreName("Store-" + storeCounter.getAndIncrement());
        CacheLoaderManagerConfig pushingCfg = new CacheLoaderManagerConfig();
        pushingCfg.addCacheLoaderConfig((CacheLoaderConfig)cfg);
        SingletonStoreConfig ssc = new SingletonStoreConfig();
        ssc.setPushStateWhenCoordinator(Boolean.valueOf(true));
        ssc.setSingletonStoreEnabled(Boolean.valueOf(true));
        cfg.setSingletonStoreConfig(ssc);
        conf.setCacheLoaderManagerConfig(pushingCfg);
        this.cm0.defineConfiguration("pushing", conf);
        ((DummyInMemoryCacheStore.Cfg)conf.getCacheLoaderManagerConfig().getFirstCacheLoaderConfig()).setStoreName("Store-" + storeCounter.getAndIncrement());
        this.cm1.defineConfiguration("pushing", conf);
        ((DummyInMemoryCacheStore.Cfg)conf.getCacheLoaderManagerConfig().getFirstCacheLoaderConfig()).setStoreName("Store-" + storeCounter.getAndIncrement());
        this.cm2.defineConfiguration("pushing", conf);
        conf = SingletonStoreTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC);
        cfg = new DummyInMemoryCacheStore.Cfg();
        cfg.setStoreName("Store-" + storeCounter.getAndIncrement());
        CacheLoaderManagerConfig nonPushingCfg = new CacheLoaderManagerConfig();
        nonPushingCfg.addCacheLoaderConfig((CacheLoaderConfig)cfg);
        ssc = new SingletonStoreConfig();
        ssc.setPushStateWhenCoordinator(Boolean.valueOf(false));
        ssc.setSingletonStoreEnabled(Boolean.valueOf(true));
        cfg.setSingletonStoreConfig(ssc);
        conf.setCacheLoaderManagerConfig(nonPushingCfg);
        this.cm0.defineConfiguration("nonPushing", conf);
        ((DummyInMemoryCacheStore.Cfg)conf.getCacheLoaderManagerConfig().getFirstCacheLoaderConfig()).setStoreName("Store-" + storeCounter.getAndIncrement());
        this.cm1.defineConfiguration("nonPushing", conf);
        ((DummyInMemoryCacheStore.Cfg)conf.getCacheLoaderManagerConfig().getFirstCacheLoaderConfig()).setStoreName("Store-" + storeCounter.getAndIncrement());
        this.cm2.defineConfiguration("nonPushing", conf);
    }

    private Cache[] getCaches(String name) {
        return new Cache[]{this.cm0.getCache(name), this.cm1.getCache(name), this.cm2.getCache(name)};
    }

    private SingletonStore[] extractStores(Cache[] caches) {
        SingletonStore[] stores = new SingletonStore[caches.length];
        int i = 0;
        for (Cache c : caches) {
            stores[i++] = (SingletonStore)TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
        }
        return stores;
    }

    private Object load(CacheStore cs, Object key) throws CacheLoaderException {
        InternalCacheEntry se = cs.load(key);
        return se == null ? null : se.getValue();
    }

    public void testPutCacheLoaderWithNoPush() throws Exception {
        Cache[] caches;
        for (Cache c : caches = this.getCaches("nonPushing")) {
            c.start();
        }
        TestingUtil.blockUntilViewsReceived(60000L, true, caches);
        int i = 1;
        for (Cache c : caches) {
            c.put((Object)("key" + i), (Object)("value" + i));
            ++i;
        }
        for (Cache c : caches) {
            for (i = 1; i < 4; ++i) {
                assert (c.get((Object)("key" + i)).equals("value" + i));
            }
        }
        SingletonStore[] stores = this.extractStores(caches);
        for (i = 1; i < 4; ++i) {
            assert (this.load((CacheStore)stores[0], "key" + i).equals("value" + i));
            assert (this.load((CacheStore)stores[1], "key" + i) == null) : "stores[1] should not have stored key key" + i;
            assert (this.load((CacheStore)stores[2], "key" + i) == null) : "stores[2] should not have stored key key" + i;
        }
        this.cm0.stop();
        TestingUtil.blockUntilViewsReceived(60000L, false, new CacheContainer[]{this.cm1, this.cm2});
        caches[1].put((Object)"key4", (Object)"value4");
        caches[2].put((Object)"key5", (Object)"value5");
        assert (this.load((CacheStore)stores[1], "key4").equals("value4"));
        assert (this.load((CacheStore)stores[1], "key5").equals("value5"));
        assert (this.load((CacheStore)stores[2], "key4") == null);
        assert (this.load((CacheStore)stores[2], "key5") == null);
        this.cm1.stop();
        TestingUtil.blockUntilViewsReceived(60000L, false, new CacheContainer[]{this.cm2});
        caches[2].put((Object)"key6", (Object)"value6");
        assert (this.load((CacheStore)stores[2], "key6").equals("value6"));
    }

    public void testPutCacheLoaderWithPush() throws Exception {
        Cache[] caches;
        for (Cache c : caches = this.getCaches("pushing")) {
            c.start();
        }
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("a-key", "a-value");
        expected.put("aa-key", "aa-value");
        expected.put("b-key", "b-value");
        expected.put("bb-key", "bb-value");
        expected.put("c-key", "c-value");
        expected.put("d-key", "d-value");
        expected.put("e-key", "e-value");
        expected.put("g-key", "g-value");
        caches[0].putAll(expected);
        SingletonStore[] stores = this.extractStores(caches);
        for (String key : expected.keySet()) {
            assert (this.load((CacheStore)stores[0], key).equals(expected.get(key)));
            assert (this.load((CacheStore)stores[1], key) == null);
            assert (this.load((CacheStore)stores[2], key) == null);
        }
        ViewChangeListener viewChangeListener = new ViewChangeListener(caches[1]);
        this.cm0.stop();
        viewChangeListener.waitForViewChange(60L, TimeUnit.SECONDS);
        this.waitForPushStateCompletion(stores[1].pushStateFuture);
        for (String key : expected.keySet()) {
            assert (this.load((CacheStore)stores[1], key).equals(expected.get(key)));
            assert (this.load((CacheStore)stores[2], key) == null);
        }
        caches[1].put((Object)"h-key", (Object)"h-value");
        caches[2].put((Object)"i-key", (Object)"i-value");
        expected.put("h-key", "h-value");
        expected.put("i-key", "i-value");
        for (String key : expected.keySet()) {
            assert (this.load((CacheStore)stores[1], key).equals(expected.get(key)));
            assert (this.load((CacheStore)stores[2], key) == null);
        }
        viewChangeListener = new ViewChangeListener(caches[2]);
        this.cm1.stop();
        viewChangeListener.waitForViewChange(60L, TimeUnit.SECONDS);
        this.waitForPushStateCompletion(stores[2].pushStateFuture);
        for (String key : expected.keySet()) {
            assert (this.load((CacheStore)stores[2], key).equals(expected.get(key)));
        }
        caches[2].put((Object)"aaa-key", (Object)"aaa-value");
        expected.put("aaa-key", "aaa-value");
        for (String key : expected.keySet()) {
            assert (this.load((CacheStore)stores[2], key).equals(expected.get(key)));
        }
    }

    public void testAvoidConcurrentStatePush() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        CountDownLatch pushStateCanFinish = new CountDownLatch(1);
        CountDownLatch secondActiveStatusChangerCanStart = new CountDownLatch(1);
        TestingSingletonStore mscl = new TestingSingletonStore(pushStateCanFinish, secondActiveStatusChangerCanStart, new SingletonStoreConfig());
        Future<?> f1 = executor.submit(this.createActiveStatusChanger(mscl));
        assert (secondActiveStatusChangerCanStart.await(1000L, TimeUnit.MILLISECONDS)) : "Failed waiting on latch";
        Future<?> f2 = executor.submit(this.createActiveStatusChanger(mscl));
        f1.get();
        f2.get();
        AssertJUnit.assertEquals((int)1, (int)mscl.getNumberCreatedTasks());
        executor.shutdownNow();
    }

    public void testPushStateTimedOut() throws Throwable {
        block2: {
            CountDownLatch pushStateCanFinish = new CountDownLatch(1);
            SingletonStoreConfig ssdc = new SingletonStoreConfig();
            ssdc.setPushStateTimeout(Long.valueOf(100L));
            TestingSingletonStore mscl = new TestingSingletonStore(pushStateCanFinish, null, ssdc);
            Future<?> f = Executors.newSingleThreadExecutor().submit(this.createActiveStatusChanger(mscl));
            pushStateCanFinish.await(200L, TimeUnit.MILLISECONDS);
            pushStateCanFinish.countDown();
            try {
                f.get();
                AssertJUnit.fail((String)"Should have timed out");
            }
            catch (ExecutionException expected) {
                Throwable e = expected.getCause().getCause().getCause();
                if (e instanceof TimeoutException) break block2;
                throw e;
            }
        }
    }

    private void waitForPushStateCompletion(Future pushThreadFuture) throws Exception {
        if (pushThreadFuture != null) {
            pushThreadFuture.get();
        }
    }

    private Callable<?> createActiveStatusChanger(SingletonStore mscl) {
        return new ActiveStatusModifier(mscl);
    }

    static class ActiveStatusModifier
    implements Callable {
        private SingletonStore scl;

        public ActiveStatusModifier(SingletonStore singleton) {
            this.scl = singleton;
        }

        public Object call() throws Exception {
            log.debug((Object)"active status modifier started");
            this.scl.activeStatusChanged(true);
            this.scl.pushStateFuture.get();
            return null;
        }
    }

    static class TestingSingletonStore
    extends SingletonStore {
        private int numberCreatedTasks = 0;
        private CountDownLatch pushStateCanFinish;
        private CountDownLatch secondActiveStatusChangerCanStart;

        public TestingSingletonStore(CountDownLatch pushStateCanFinish, CountDownLatch secondActiveStatusChangerCanStart, SingletonStoreConfig cfg) {
            super(null, null, cfg);
            this.pushStateCanFinish = pushStateCanFinish;
            this.secondActiveStatusChangerCanStart = secondActiveStatusChangerCanStart;
        }

        public int getNumberCreatedTasks() {
            return this.numberCreatedTasks;
        }

        public void setNumberCreatedTasks(int numberCreatedTasks) {
            this.numberCreatedTasks = numberCreatedTasks;
        }

        protected Callable<?> createPushStateTask() {
            return new Callable(){

                public Object call() throws Exception {
                    TestingSingletonStore.this.numberCreatedTasks++;
                    try {
                        if (TestingSingletonStore.this.secondActiveStatusChangerCanStart != null) {
                            TestingSingletonStore.this.secondActiveStatusChangerCanStart.countDown();
                        }
                        TestingSingletonStore.this.pushStateCanFinish.await();
                    }
                    catch (InterruptedException e) {
                        AssertJUnit.fail((String)"ActiveStatusModifier interrupted");
                    }
                    return null;
                }
            };
        }

        protected void awaitForPushToFinish(Future future, long timeout, TimeUnit unit) {
            this.pushStateCanFinish.countDown();
            super.awaitForPushToFinish(future, timeout, unit);
        }
    }
}

