/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import org.infinispan.Cache;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.config.Configuration;
import org.infinispan.distribution.MagicKey;
import org.infinispan.interceptors.DistributionInterceptor;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.lock.FailInterceptor;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(testName="lock.StaleLocksOnPrepareFailureTest", groups={"functional"})
@CleanupAfterMethod
public class StaleLocksOnPrepareFailureTest
extends MultipleCacheManagersTest {
    public static final int NUM_CACHES = 10;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration cfg = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.DIST_SYNC);
        cfg.setNumOwners(10);
        cfg.setLockAcquisitionTimeout(100L);
        for (int i = 0; i < 10; ++i) {
            EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(cfg);
            this.registerCacheManager(new CacheContainer[]{cm});
        }
        this.waitForClusterToForm();
    }

    public void testModsCommit() throws Exception {
        this.doTest(true);
    }

    private void doTest(boolean mods) throws Exception {
        Cache c1 = this.cache(0);
        Cache c2 = this.cache(5);
        FailInterceptor interceptor = new FailInterceptor();
        interceptor.failFor(PrepareCommand.class);
        InterceptorChain ic = TestingUtil.extractComponent(c2, InterceptorChain.class);
        ic.addInterceptorBefore((CommandInterceptor)interceptor, DistributionInterceptor.class);
        MagicKey k1 = new MagicKey(c1, "k1");
        this.tm(c1).begin();
        c1.put((Object)k1, (Object)"v1");
        try {
            this.tm(c1).commit();
            assert (false) : "Commit should have failed";
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i = 0; i < 10; ++i) {
            this.assertNotLocked(this.cache(i), (Object)k1);
        }
    }
}

