/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock;

import java.util.concurrent.CountDownLatch;
import org.infinispan.config.Configuration;
import org.infinispan.lock.singlelock.AbstractCrashTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.tm.DummyTransaction;
import org.testng.annotations.Test;

@Test
public abstract class AbstractInitiatorCrashTest
extends AbstractCrashTest {
    public AbstractInitiatorCrashTest(Configuration.CacheMode cacheMode, LockingMode lockingMode, Boolean useSynchronization) {
        super(cacheMode, lockingMode, useSynchronization);
    }

    public void testInitiatorCrashesBeforeReleasingLock() throws Exception {
        CountDownLatch releaseLocksLatch = new CountDownLatch(1);
        this.prepareCache(releaseLocksLatch);
        Object k = this.getKeyForCache(2);
        this.beginAndCommitTx(k, 1);
        releaseLocksLatch.await();
        assert (this.checkTxCount(0, 0, 1));
        assert (this.checkTxCount(1, 0, 0));
        assert (this.checkTxCount(2, 0, 1));
        this.assertNotLocked(this.cache(0), k);
        this.assertNotLocked(this.cache(1), k);
        this.assertLocked(this.cache(2), k);
        this.killMember(1);
        this.cacheManagers.remove(1);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return AbstractInitiatorCrashTest.this.checkTxCount(0, 0, 0) && AbstractInitiatorCrashTest.this.checkTxCount(1, 0, 0);
            }
        });
        this.assertNotLocked(k);
    }

    public void testInitiatorNodeCrashesBeforeCommit() throws Exception {
        Object k = this.getKeyForCache(2);
        this.tm(1).begin();
        this.cache(1).put(k, (Object)"v");
        DummyTransaction transaction = (DummyTransaction)this.tm(1).getTransaction();
        transaction.runPrepare();
        this.tm(1).suspend();
        this.assertNotLocked(this.cache(0), k);
        this.assertNotLocked(this.cache(1), k);
        this.assertLocked(this.cache(2), k);
        this.checkTxCount(0, 0, 1);
        this.checkTxCount(1, 1, 0);
        this.checkTxCount(2, 0, 1);
        this.killMember(1);
        this.cacheManagers.remove(1);
        this.assertNotLocked(k);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return AbstractInitiatorCrashTest.this.checkTxCount(0, 0, 0) && AbstractInitiatorCrashTest.this.checkTxCount(1, 0, 0);
            }
        });
    }
}

