/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock.pessimistic;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.infinispan.config.Configuration;
import org.infinispan.lock.singlelock.AbstractLockOwnerCrashTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.tm.DummyTransaction;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.pessimistic.LockOwnerCrashPessimisticTest")
@CleanupAfterMethod
public class LockOwnerCrashPessimisticTest
extends AbstractLockOwnerCrashTest {
    public LockOwnerCrashPessimisticTest() {
        super(Configuration.CacheMode.DIST_SYNC, LockingMode.PESSIMISTIC, false);
    }

    public void testLockOwnerCrashesBeforePrepare() throws Exception {
        final Object k = this.getKeyForCache(2);
        this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    LockOwnerCrashPessimisticTest.this.tm(1).begin();
                    LockOwnerCrashPessimisticTest.this.cache(1).put(k, (Object)"v");
                    LockOwnerCrashPessimisticTest.this.transaction = (DummyTransaction)LockOwnerCrashPessimisticTest.this.tm(1).getTransaction();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }, false);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return LockOwnerCrashPessimisticTest.this.checkTxCount(0, 0, 1) && LockOwnerCrashPessimisticTest.this.checkTxCount(1, 1, 0) && LockOwnerCrashPessimisticTest.this.checkTxCount(2, 0, 1);
            }
        });
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return !LockOwnerCrashPessimisticTest.this.checkLocked(0, k) && !LockOwnerCrashPessimisticTest.this.checkLocked(1, k) && LockOwnerCrashPessimisticTest.this.checkLocked(2, k);
            }
        });
        this.killMember(2);
        this.cacheManagers.remove(2);
        assert (this.caches().size() == 2);
        this.tm(1).resume((Transaction)this.transaction);
        this.tm(1).commit();
        Assert.assertEquals((Object)this.cache(0).get(k), (Object)"v");
        Assert.assertEquals((Object)this.cache(1).get(k), (Object)"v");
        this.assertNotLocked(k);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return LockOwnerCrashPessimisticTest.this.checkTxCount(0, 0, 0) && LockOwnerCrashPessimisticTest.this.checkTxCount(1, 0, 0);
            }
        });
    }

    public void testLockOwnerCrashesBeforePrepareAndLockIsStillHeld() throws Exception {
        final Object k = this.getKeyForCache(2);
        this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    LockOwnerCrashPessimisticTest.this.tm(1).begin();
                    LockOwnerCrashPessimisticTest.this.cache(1).put(k, (Object)"v");
                    LockOwnerCrashPessimisticTest.this.transaction = (DummyTransaction)LockOwnerCrashPessimisticTest.this.tm(1).getTransaction();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }, false);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return !LockOwnerCrashPessimisticTest.this.checkLocked(0, k) && !LockOwnerCrashPessimisticTest.this.checkLocked(1, k) && LockOwnerCrashPessimisticTest.this.checkLocked(2, k);
            }
        });
        this.killMember(2);
        this.cacheManagers.remove(2);
        assert (this.caches().size() == 2);
        this.tm(0).begin();
        try {
            this.cache(0).put(k, (Object)"v1");
            assert (false);
        }
        catch (Exception e) {
            this.tm(0).suspend();
        }
        this.tm(1).resume((Transaction)this.transaction);
        this.tm(1).commit();
        Assert.assertEquals((Object)this.cache(0).get(k), (Object)"v");
        Assert.assertEquals((Object)this.cache(1).get(k), (Object)"v");
        this.assertNotLocked(k);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return LockOwnerCrashPessimisticTest.this.checkTxCount(0, 0, 0) && LockOwnerCrashPessimisticTest.this.checkTxCount(1, 0, 0);
            }
        });
    }

    public void lockOwnerCrasherBetweenPrepareAndCommit1() throws Exception {
        this.testCrashBeforeCommit(true);
    }

    public void lockOwnerCrasherBetweenPrepareAndCommit2() throws Exception {
        this.testCrashBeforeCommit(false);
    }

    private void testCrashBeforeCommit(final boolean crashBeforePrepare) throws NotSupportedException, SystemException, InvalidTransactionException, HeuristicMixedException, RollbackException, HeuristicRollbackException {
        final Object k = this.getKeyForCache(2);
        this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    LockOwnerCrashPessimisticTest.this.tm(1).begin();
                    LockOwnerCrashPessimisticTest.this.cache(1).put(k, (Object)"v");
                    LockOwnerCrashPessimisticTest.this.transaction = (DummyTransaction)LockOwnerCrashPessimisticTest.this.tm(1).getTransaction();
                    if (!crashBeforePrepare) {
                        LockOwnerCrashPessimisticTest.this.transaction.runPrepare();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }, false);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return LockOwnerCrashPessimisticTest.this.checkTxCount(0, 0, 1) && LockOwnerCrashPessimisticTest.this.checkTxCount(1, 1, 0) && LockOwnerCrashPessimisticTest.this.checkTxCount(2, 0, 1);
            }
        });
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return !LockOwnerCrashPessimisticTest.this.checkLocked(0, k) && !LockOwnerCrashPessimisticTest.this.checkLocked(1, k) && LockOwnerCrashPessimisticTest.this.checkLocked(2, k);
            }
        });
        this.killMember(2);
        this.cacheManagers.remove(2);
        assert (this.caches().size() == 2);
        this.tm(1).begin();
        try {
            this.cache(1).put(k, (Object)"v2");
            assert (false) : "Exception expected as lock cannot be acquired on k=" + k;
        }
        catch (Exception e) {
            this.tm(1).rollback();
        }
        this.tm(0).begin();
        try {
            this.cache(0).put(k, (Object)"v3");
            assert (false) : "Exception expected as lock cannot be acquired on k=" + k;
        }
        catch (Exception e) {
            this.tm(0).rollback();
        }
        this.tm(1).resume((Transaction)this.transaction);
        if (!crashBeforePrepare) {
            this.transaction.runCommitTx();
        } else {
            this.tm(1).commit();
        }
        assert (this.cache(0).get(k).equals("v"));
        assert (this.cache(1).get(k).equals("v"));
        this.assertNotLocked(k);
    }
}

