/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.easymock.EasyMock;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.manager.CacheContainer;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.CacheNotifierTxTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.cachelistener.CacheNotifierTest")
public class CacheNotifierTest
extends AbstractInfinispanTest {
    private Cache<Object, Object> cache;
    private CacheNotifier mockNotifier;
    private CacheNotifier origNotifier;
    private CacheContainer cm;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Configuration c = new Configuration();
        c.fluent().transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        c.setCacheMode(Configuration.CacheMode.LOCAL);
        c.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cm = TestCacheManagerFactory.createCacheManager(c);
        this.cache = this.cm.getCache();
        this.mockNotifier = (CacheNotifier)EasyMock.createMock(CacheNotifier.class);
        this.origNotifier = TestingUtil.replaceComponent(this.cache, CacheNotifier.class, this.mockNotifier, true);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.replaceComponent(this.cache, CacheNotifier.class, this.origNotifier, true);
        TestingUtil.killCaches(this.cache);
        this.cm.stop();
    }

    @AfterClass
    public void destroyManager() {
        TestingUtil.killCacheManagers(this.cache.getCacheManager());
    }

    public void testVisit() throws Exception {
        this.initCacheData(Collections.singletonMap("key", "value"));
        this.mockNotifier.notifyCacheEntryVisited(EasyMock.eq((Object)"key"), EasyMock.eq((Object)"value"), EasyMock.eq((boolean)true), (InvocationContext)EasyMock.isA(InvocationContext.class));
        EasyMock.expectLastCall().once();
        this.mockNotifier.notifyCacheEntryVisited(EasyMock.eq((Object)"key"), EasyMock.eq((Object)"value"), EasyMock.eq((boolean)false), (InvocationContext)EasyMock.isA(InvocationContext.class));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.mockNotifier});
        this.cache.get((Object)"key");
        EasyMock.verify((Object[])new Object[]{this.mockNotifier});
    }

    public void testRemoveData() throws Exception {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("key", "value");
        data.put("key2", "value2");
        this.initCacheData(data);
        this.mockNotifier.notifyCacheEntryRemoved(EasyMock.eq((Object)"key2"), EasyMock.eq((Object)"value2"), EasyMock.eq((boolean)true), (InvocationContext)EasyMock.isA(InvocationContext.class));
        EasyMock.expectLastCall().once();
        this.mockNotifier.notifyCacheEntryRemoved(EasyMock.eq((Object)"key2"), EasyMock.isNull(), EasyMock.eq((boolean)false), (InvocationContext)EasyMock.isA(InvocationContext.class));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.mockNotifier});
        this.cache.remove((Object)"key2");
        EasyMock.verify((Object[])new Object[]{this.mockNotifier});
    }

    public void testPutMap() throws Exception {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("key", "value");
        data.put("key2", "value2");
        this.expectSingleEntryCreated("key", "value");
        this.expectSingleEntryCreated("key2", "value2");
        EasyMock.replay((Object[])new Object[]{this.mockNotifier});
        this.cache.putAll(data);
        EasyMock.verify((Object[])new Object[]{this.mockNotifier});
    }

    public void testOnlyModification() throws Exception {
        this.initCacheData(Collections.singletonMap("key", "value"));
        this.mockNotifier.notifyCacheEntryModified(EasyMock.eq((Object)"key"), EasyMock.eq((Object)"value"), EasyMock.eq((boolean)true), (InvocationContext)EasyMock.isA(InvocationContext.class));
        EasyMock.expectLastCall().once();
        this.mockNotifier.notifyCacheEntryModified(EasyMock.eq((Object)"key"), EasyMock.eq((Object)"value2"), EasyMock.eq((boolean)false), (InvocationContext)EasyMock.isA(InvocationContext.class));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.mockNotifier});
        this.cache.put((Object)"key", (Object)"value2");
        EasyMock.verify((Object[])new Object[]{this.mockNotifier});
    }

    public void testNonexistentVisit() throws Exception {
        this.cache.get((Object)"doesNotExist");
        EasyMock.replay((Object[])new Object[]{this.mockNotifier});
        EasyMock.verify((Object[])new Object[]{this.mockNotifier});
    }

    public void testNonexistentRemove() throws Exception {
        this.cache.remove((Object)"doesNotExist");
        EasyMock.replay((Object[])new Object[]{this.mockNotifier});
        EasyMock.verify((Object[])new Object[]{this.mockNotifier});
    }

    public void testCreation() throws Exception {
        this.expectSingleEntryCreated("key", "value");
        EasyMock.replay((Object[])new Object[]{this.mockNotifier});
        this.cache.put((Object)"key", (Object)"value");
        EasyMock.verify((Object[])new Object[]{this.mockNotifier});
    }

    private void initCacheData(Map<String, String> data) {
        this.mockNotifier.notifyCacheEntryCreated(EasyMock.anyObject(), EasyMock.anyBoolean(), (InvocationContext)EasyMock.isA(InvocationContext.class));
        EasyMock.expectLastCall().anyTimes();
        this.mockNotifier.notifyCacheEntryModified(EasyMock.anyObject(), EasyMock.anyObject(), EasyMock.anyBoolean(), (InvocationContext)EasyMock.isA(InvocationContext.class));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockNotifier});
        this.cache.putAll(data);
        EasyMock.verify((Object[])new Object[]{this.mockNotifier});
        EasyMock.reset((Object[])new Object[]{this.mockNotifier});
    }

    private void expectSingleEntryCreated(Object key, Object value) {
        CacheNotifierTxTest.expectSingleEntryCreated(key, value, this.mockNotifier);
    }
}

