/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting;

import org.infinispan.CacheException;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.NamedCacheNotFoundException;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.annotations.Test;

@Test(testName="remoting.NonExistentCacheTest", groups={"functional"})
public class NonExistentCacheTest
extends AbstractInfinispanTest {
    public void testStrictPeerToPeer() {
        this.doTest(true);
    }

    public void testNonStrictPeerToPeer() {
        this.doTest(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(boolean strict) {
        EmbeddedCacheManager cm2;
        EmbeddedCacheManager cm1;
        block10: {
            cm1 = null;
            cm2 = null;
            try {
                Configuration c = new Configuration();
                c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
                c.fluent().transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
                GlobalConfiguration gc = GlobalConfiguration.getClusteredDefault();
                gc.setStrictPeerToPeer(strict);
                cm1 = TestCacheManagerFactory.createCacheManager(gc, c);
                cm2 = TestCacheManagerFactory.createCacheManager(gc, c);
                cm1.getCache();
                cm2.getCache();
                cm1.getCache().put((Object)"k", (Object)"v");
                assert ("v".equals(cm1.getCache().get((Object)"k")));
                assert ("v".equals(cm2.getCache().get((Object)"k")));
                cm1.defineConfiguration("newCache", c);
                if (strict) {
                    try {
                        cm1.getCache("newCache").put((Object)"k", (Object)"v");
                        assert (false) : "Should have failed!";
                        break block10;
                    }
                    catch (CacheException e) {
                        assert (e.getCause() instanceof NamedCacheNotFoundException);
                        break block10;
                    }
                }
                cm1.getCache("newCache").put((Object)"k", (Object)"v");
                assert ("v".equals(cm1.getCache("newCache").get((Object)"k")));
            }
            catch (Throwable throwable) {
                TestingUtil.killCacheManagers(cm1, cm2);
                throw throwable;
            }
        }
        TestingUtil.killCacheManagers(cm1, cm2);
    }
}

