/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test;

import java.util.HashSet;
import java.util.Set;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterTest;

public class AbstractInfinispanTest {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Set<Thread> spawnedThreads = new HashSet<Thread>();

    @AfterTest(alwaysRun=true)
    protected void killSpawnedThreads() {
        for (Thread t : this.spawnedThreads) {
            if (!t.isAlive()) continue;
            t.interrupt();
        }
    }

    protected void eventually(Condition ec, long timeout) {
        int loops = 10;
        long sleepDuration = timeout / (long)loops;
        try {
            for (int i = 0; i < loops && !ec.isSatisfied(); ++i) {
                Thread.sleep(sleepDuration);
            }
            Assert.assertEquals((boolean)true, (boolean)ec.isSatisfied());
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected!", e);
        }
    }

    protected Thread fork(Runnable r, boolean waitForCompletion) {
        String name = "ForkThread-" + this.getClass().getSimpleName() + "-" + r.hashCode();
        this.log.tracef("About to start thread '%s' as child of thread '%s'", (Object)name, (Object)Thread.currentThread().getName());
        final Thread t = new Thread((Runnable)new RunnableWrapper(r), name);
        this.spawnedThreads.add(t);
        t.start();
        if (waitForCompletion) {
            this.eventually(new Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return t.getState().equals((Object)Thread.State.TERMINATED);
                }
            });
        }
        return t;
    }

    protected void eventually(Condition ec) {
        this.eventually(ec, 10000L);
    }

    protected static interface Condition {
        public boolean isSatisfied() throws Exception;
    }

    public final class RunnableWrapper
    implements Runnable {
        final Runnable realOne;

        public RunnableWrapper(Runnable realOne) {
            this.realOne = realOne;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                AbstractInfinispanTest.this.log.trace((Object)"Started fork thread..");
                this.realOne.run();
            }
            catch (Throwable e) {
                AbstractInfinispanTest.this.log.trace((Object)"Exiting fork thread due to exception", e);
            }
            finally {
                AbstractInfinispanTest.this.log.trace((Object)"Exiting fork thread.");
            }
        }
    }
}

