/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.rehash.XAResourceAdapter;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.FailureDuringPrepareTest")
@CleanupAfterMethod
public class FailureDuringPrepareTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = FailureDuringPrepareTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, true);
        c.fluent().hash().numOwners(Integer.valueOf(3));
        this.createCluster(c, 3);
        this.waitForClusterToForm();
    }

    public void testResourceCleanedIfPrepareFails() throws Exception {
        this.runTest(false);
    }

    public void testResourceCleanedIfPrepareFails2() throws Exception {
        this.runTest(true);
    }

    private void runTest(boolean multipleResources) throws NotSupportedException, SystemException, RollbackException {
        this.advancedCache(1).addInterceptor(new CommandInterceptor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
                try {
                    Object object = super.visitPrepareCommand(ctx, command);
                    return object;
                }
                finally {
                    throw new RuntimeException("Induced fault!");
                }
            }
        }, 2);
        this.tm(0).begin();
        this.cache(0).put((Object)"k", (Object)"v");
        if (multipleResources) {
            this.tm(0).getTransaction().enlistResource((XAResource)new XAResourceAdapter());
        }
        Assert.assertEquals((int)this.lockManager(0).getNumberOfLocksHeld(), (int)0);
        Assert.assertEquals((int)this.lockManager(1).getNumberOfLocksHeld(), (int)0);
        Assert.assertEquals((int)this.lockManager(2).getNumberOfLocksHeld(), (int)0);
        try {
            this.tm(0).commit();
            assert (false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Assert.assertEquals((int)this.lockManager(0).getNumberOfLocksHeld(), (int)0);
        Assert.assertEquals((int)this.lockManager(1).getNumberOfLocksHeld(), (int)0);
        Assert.assertEquals((int)this.lockManager(2).getNumberOfLocksHeld(), (int)0);
    }
}

