/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import javax.transaction.RollbackException;
import javax.transaction.TransactionManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.MarkAsRollbackTest")
public class MarkAsRollbackTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(this.getDefaultStandaloneConfig(true));
        this.cache = cm.getCache();
        return cm;
    }

    public void testMarkAsRollbackAfterMods() throws Exception {
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        assert (tm != null);
        tm.begin();
        this.cache.put((Object)"k", (Object)"v");
        assert (this.cache.get((Object)"k").equals("v"));
        tm.setRollbackOnly();
        try {
            tm.commit();
            assert (false) : "Should have rolled back";
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        assert (tm.getTransaction() == null) : "There should be no transaction in scope anymore!";
        assert (this.cache.get((Object)"k") == null) : "Expected a null but was " + this.cache.get((Object)"k");
    }

    public void testMarkAsRollbackBeforeMods() throws Exception {
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        assert (tm != null);
        tm.begin();
        tm.setRollbackOnly();
        try {
            this.cache.put((Object)"k", (Object)"v");
            assert (false) : "Should have throw an illegal state exception";
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            tm.commit();
            assert (false) : "Should have rolled back";
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        assert (tm.getTransaction() == null) : "There should be no transaction in scope anymore!";
        assert (this.cache.get((Object)"k") == null) : "Expected a null but was " + this.cache.get((Object)"k");
    }
}

