/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.OnePhaseXATest", description="See ISPN-156 for details.")
public class OnePhaseXATest
extends AbstractInfinispanTest {
    private List<Cache> caches;
    private List<EmbeddedCacheManager> cacheContainers;
    public static final int CACHES_NUM = 2;

    public void testMultipleCaches() throws Exception {
        int i = 0;
        for (Cache c : this.caches) {
            TransactionManager tm = TestingUtil.getTransactionManager(c);
            tm.begin();
            c.put((Object)("key" + i), (Object)"value");
            tm.commit();
            ++i;
        }
        i = 0;
        for (Cache c : this.caches) {
            assert ("value".equals(c.get((Object)"key0"))) : "Failed getting value for key0 on cache " + i;
            assert ("value".equals(c.get((Object)"key1"))) : "Failed getting value for key1 on cache " + i;
            ++i;
        }
    }

    @BeforeTest
    public void setUp() throws Exception {
        this.caches = new ArrayList<Cache>();
        this.cacheContainers = new ArrayList<EmbeddedCacheManager>();
        for (int i = 0; i < 2; ++i) {
            this.caches.add(this.getCache());
        }
    }

    @AfterTest
    public void tearDown() {
        if (this.caches != null) {
            TestingUtil.killCacheManagers(this.cacheContainers);
        }
    }

    private Cache getCache() {
        GlobalConfiguration gc = GlobalConfiguration.getClusteredDefault();
        Configuration c = new Configuration();
        c.setInvocationBatchingEnabled(true);
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c.setSyncReplTimeout(30000L);
        c.setLockAcquisitionTimeout(60000L);
        c.setUseLockStriping(false);
        c.setSyncCommitPhase(true);
        EmbeddedCacheManager container = TestCacheManagerFactory.createCacheManager(gc, c);
        this.cacheContainers.add(container);
        return container.getCache("TestCache");
    }
}

