/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.tm.DummyTransaction;
import org.infinispan.tx.recovery.RecoveryTestUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.ParticipantFailsAfterPrepareTest")
public class ParticipantFailsAfterPrepareTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration configuration = ParticipantFailsAfterPrepareTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, true);
        configuration.fluent().locking().useLockStriping(Boolean.valueOf(false));
        configuration.fluent().transaction().transactionManagerLookupClass(DummyTransactionManagerLookup.class);
        configuration.fluent().clustering().hash().rehashEnabled(Boolean.valueOf(false));
        configuration.fluent().clustering().hash().numOwners(Integer.valueOf(3));
        this.createCluster(configuration, 4);
        this.waitForClusterToForm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonOriginatorFailsAfterPrepare() throws Exception {
        Object key = this.getKeyForCache(0);
        DummyTransaction dummyTransaction = RecoveryTestUtil.beginAndSuspendTx(this.cache(0), key);
        RecoveryTestUtil.prepareTransaction(dummyTransaction);
        int indexToKill = -1;
        List locate = this.advancedCache(0).getDistributionManager().getConsistentHash().locate(key, 3);
        for (int i = 3; i > 0; --i) {
            if (!locate.contains(this.address(i))) continue;
            indexToKill = i;
            break;
        }
        System.out.println("indexToKill = " + indexToKill);
        assert (indexToKill > 0);
        Address toKill = this.address(indexToKill);
        TestingUtil.killCacheManagers(this.manager(indexToKill));
        List<Cache> participants = this.getAliveParticipants(indexToKill);
        TestingUtil.blockUntilViewsReceived(60000, false, participants);
        boolean noLocks = false;
        for (Cache c : participants) {
            if (TestingUtil.extractLockManager(c).getNumberOfLocksHeld() != 0) continue;
            noLocks = true;
        }
        assert (noLocks);
        this.log.trace((Object)("About to commit. Killed node is: " + toKill));
        try {
            RecoveryTestUtil.commitTransaction(dummyTransaction);
        }
        catch (Throwable t) {
            t.printStackTrace();
            assert (false);
        }
        finally {
            for (Cache c : participants) {
                Assert.assertEquals((int)TestingUtil.extractLockManager(c).getNumberOfLocksHeld(), (int)0);
                Assert.assertEquals((int)c.keySet().size(), (int)1);
            }
        }
    }

    private List<Cache> getAliveParticipants(int indexToKill) {
        ArrayList<Cache> participants = new ArrayList<Cache>();
        for (int i = 0; i < 4; ++i) {
            if (i == indexToKill) continue;
            participants.add(this.cache(i));
        }
        return participants;
    }
}

