/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.RemoteLockCleanupStressTest", invocationCount=20, enabled=false)
@CleanupAfterMethod
public class RemoteLockCleanupStressTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(RemoteLockCleanupStressTest.class);
    EmbeddedCacheManager cm1;
    EmbeddedCacheManager cm2;
    String key = "locked-counter";

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.REPL_SYNC);
        c.setFetchInMemoryState(true);
        c.setLockAcquisitionTimeout(1500L);
        this.cm1 = this.addClusterEnabledCacheManager(c);
        this.cm2 = this.addClusterEnabledCacheManager(c);
    }

    public void testLockRelease() {
        Thread t1 = new Thread(new CounterTask(this.cm1));
        Thread t2 = new Thread(new CounterTask(this.cm2));
        t1.start();
        t2.start();
        TestingUtil.sleepThread(1000L);
        t2.interrupt();
        TestingUtil.killCacheManagers(this.cm2);
        TestingUtil.sleepThread(1100L);
        t1.interrupt();
        LockManager lm = TestingUtil.extractComponent(this.cm1.getCache(), LockManager.class);
        Object owner = lm.getOwner((Object)this.key);
        assert (this.ownerIsLocalOrUnlocked(owner, this.cm1.getAddress())) : "Bad lock owner " + owner;
    }

    private boolean ownerIsLocalOrUnlocked(Object owner, Address self) {
        if (owner == null) {
            return true;
        }
        if (owner instanceof GlobalTransaction) {
            GlobalTransaction gtx = (GlobalTransaction)owner;
            return gtx.getAddress().equals(self);
        }
        return false;
    }

    class CounterTask
    implements Runnable {
        EmbeddedCacheManager cm;

        CounterTask(EmbeddedCacheManager cm) {
            this.cm = cm;
        }

        @Override
        public void run() {
            for (int i = 0; i < 25; ++i) {
                this.run_();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run_() {
            Cache cache = this.cm.getCache();
            TransactionManager tx = cache.getAdvancedCache().getTransactionManager();
            try {
                tx.begin();
            }
            catch (Exception ex) {
                log.debug((Object)"Exception starting transaction", (Throwable)ex);
            }
            try {
                log.debug((Object)("aquiring lock on cache " + cache.getName() + " key " + RemoteLockCleanupStressTest.this.key + "..."));
                cache.getAdvancedCache().lock(new Object[]{RemoteLockCleanupStressTest.this.key});
                Integer val = (Integer)cache.get((Object)RemoteLockCleanupStressTest.this.key);
                log.debug((Object)("current value : " + val));
                if (val == null) {
                    val = 0;
                } else {
                    Integer n = val;
                    Integer n2 = val = Integer.valueOf(val + 1);
                }
                cache.put((Object)RemoteLockCleanupStressTest.this.key, (Object)val);
                TestingUtil.sleepRandom(200);
                log.debug((Object)"commit...");
                tx.commit();
                log.debug((Object)"done commit");
            }
            catch (Exception ex) {
                try {
                    log.debug((Object)("rollback... " + ex.getLocalizedMessage()));
                    tx.rollback();
                    log.debug((Object)"done rollback");
                }
                catch (Exception rex) {
                    log.debug((Object)"Exception rolling back", (Throwable)rex);
                }
            }
            finally {
                try {
                    log.debug((Object)"tx status at the end : ");
                    switch (tx.getStatus()) {
                        case 0: {
                            log.debug((Object)"active");
                            break;
                        }
                        case 3: {
                            log.debug((Object)"committed");
                            break;
                        }
                        case 8: {
                            log.debug((Object)"committing");
                            break;
                        }
                        case 1: {
                            log.debug((Object)"makerd rollback");
                            break;
                        }
                        case 6: {
                            log.debug((Object)"no transaction");
                            break;
                        }
                        case 2: {
                            log.debug((Object)"preprared");
                            break;
                        }
                        case 7: {
                            log.debug((Object)"preparing");
                            break;
                        }
                        case 4: {
                            log.debug((Object)"rolledback");
                            break;
                        }
                        case 9: {
                            log.debug((Object)"rolling back");
                            break;
                        }
                        case 5: {
                            log.debug((Object)"unknown");
                            break;
                        }
                        default: {
                            log.debug((Object)tx.getStatus());
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    log.debug((Object)"Exception retrieving transaction status", (Throwable)ex);
                }
            }
        }
    }
}

