/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.locking;

import java.util.Collections;
import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.xa.Xid;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.transaction.tm.DummyTransaction;
import org.infinispan.transaction.tm.DummyTransactionManager;

public abstract class AbstractLocalTest
extends SingleCacheManagerTest {
    public void testPut() throws Exception {
        this.tm().begin();
        this.cache.put((Object)"k", (Object)"v");
        this.assertLocking();
    }

    public void testRemove() throws Exception {
        this.tm().begin();
        this.cache.remove((Object)"k");
        this.assertLocking();
    }

    public void testReplace() throws Exception {
        this.cache.put((Object)"k", (Object)"initial");
        this.tm().begin();
        this.cache.replace((Object)"k", (Object)"v");
        this.assertLocking();
    }

    public void testClear() throws Exception {
        this.cache.put((Object)"k", (Object)"v");
        this.tm().begin();
        this.cache.clear();
        this.assertLocking();
    }

    public void testPutAll() throws Exception {
        Map<String, String> m = Collections.singletonMap("k", "v");
        this.tm().begin();
        this.cache.putAll(m);
        this.assertLocking();
    }

    protected abstract void assertLocking();

    protected void commit() {
        DummyTransactionManager dtm = (DummyTransactionManager)this.tm();
        try {
            dtm.firstEnlistedResource().commit(this.getXid(), true);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected void prepare() {
        DummyTransactionManager dtm = (DummyTransactionManager)this.tm();
        try {
            dtm.firstEnlistedResource().prepare(this.getXid());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private Xid getXid() throws SystemException {
        DummyTransaction dummyTransaction = (DummyTransaction)this.tm().getTransaction();
        Xid xid = dummyTransaction.getXid();
        return xid;
    }
}

