/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.locking;

import javax.transaction.Transaction;
import org.infinispan.config.Configuration;
import org.infinispan.transaction.LockingMode;
import org.infinispan.tx.locking.AbstractClusteredTxTest;
import org.infinispan.util.concurrent.TimeoutException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.locking.PessimisticReplTxTest")
public class PessimisticReplTxTest
extends AbstractClusteredTxTest {
    Configuration conf;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.conf.fluent().transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.conf.fluent().locking().lockAcquisitionTimeout(Long.valueOf(10L));
        this.createCluster(this.conf, 2);
        assert (this.conf.isTransactionalCache());
        this.waitForClusterToForm();
        System.out.println("PessimisticReplTxTest.createCacheManagers");
    }

    public PessimisticReplTxTest() {
        this.k = "k";
        this.conf = PessimisticReplTxTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTxInProgress1() throws Exception {
        this.log.info((Object)"test :: start");
        try {
            this.test(0, 0);
        }
        finally {
            this.log.info((Object)"test :: end");
        }
    }

    public void testTxInProgress2() throws Exception {
        this.test(0, 1);
    }

    public void testTxInProgress3() throws Exception {
        this.test(1, 1);
    }

    public void testTxInProgress4() throws Exception {
        this.test(1, 0);
    }

    private void test(int firstTxIndex, int secondTxIndex) throws Exception {
        this.tm(firstTxIndex).begin();
        this.cache(firstTxIndex).put(this.k, (Object)"v1");
        Transaction tx1 = this.tm(firstTxIndex).suspend();
        this.tm(secondTxIndex).begin();
        try {
            this.cache(secondTxIndex).put(this.k, (Object)"v2");
            assert (false) : "Timeout exception expected";
        }
        catch (TimeoutException e) {
            this.tm(secondTxIndex).suspend();
        }
        this.tm(firstTxIndex).resume(tx1);
        this.tm(firstTxIndex).commit();
        assert (this.cache(0).get(this.k).equals("v1"));
        this.log.info((Object)"Before get...");
        this.assertNotLocked(this.k);
        assert (this.cache(1).get(this.k).equals("v1"));
        this.assertNotLocked(this.k);
    }

    public void simpleTest() throws Exception {
        this.tm(0).begin();
        this.cache(0).put(this.k, (Object)"v");
        this.tm(0).commit();
        Assert.assertEquals((Object)this.cache(0).get(this.k), (Object)"v");
        Assert.assertEquals((Object)this.cache(1).get(this.k), (Object)"v");
    }

    @Override
    protected void assertLocking() {
        Assert.assertTrue((boolean)this.lockManager(0).isLocked(this.k));
        Assert.assertTrue((boolean)this.lockManager(1).isLocked(this.k));
        this.prepare();
        Assert.assertTrue((boolean)this.lockManager(0).isLocked(this.k));
        Assert.assertTrue((boolean)this.lockManager(1).isLocked(this.k));
        this.commit();
        Assert.assertFalse((boolean)this.lockManager(0).isLocked(this.k));
        Assert.assertFalse((boolean)this.lockManager(1).isLocked(this.k));
    }
}

