/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.lockreordering;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.config.Configuration;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.tx.lockreordering.LocalLockReorderingTest;
import org.infinispan.tx.lockreordering.StresserThread;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.lockreordering.DistLockReorderingTest")
public class DistLockReorderingTest
extends MultipleCacheManagersTest {
    List keys;
    protected Configuration.CacheMode cacheMode = Configuration.CacheMode.DIST_SYNC;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = DistLockReorderingTest.getDefaultClusteredConfig(this.cacheMode, true);
        c.fluent().transaction().cacheStopTimeout(Integer.valueOf(1));
        c.fluent().transaction().locking().lockAcquisitionTimeout(Long.valueOf(30000L));
        this.createCluster(c, 2);
        this.waitForClusterToForm();
        this.buildKeys();
    }

    void buildKeys() {
        int node = (int)(System.nanoTime() % 2L);
        MurmurHash3 hashFunction = new MurmurHash3();
        this.keys = new ArrayList(2);
        Object firstKey = this.getKeyForCache(node);
        this.keys.add(firstKey);
        while (this.keys.size() < 2) {
            Object keyForCache = this.getKeyForCache(node);
            int hash = hashFunction.hash(keyForCache);
            if (hash == hashFunction.hash(firstKey)) continue;
            this.keys.add(keyForCache);
        }
    }

    public void testWithPut(Method m) throws Exception {
        LocalLockReorderingTest.runTest(StresserThread.PUT_PERFORMER, this.cache(0), this.cache(1), this.keys, this.getThreadPrefix(m));
    }

    public void testWithRemove(Method m) throws InterruptedException {
        LocalLockReorderingTest.runTest(StresserThread.REMOVE_PERFORMER, this.cache(0), this.cache(1), this.keys, this.getThreadPrefix(m));
    }

    public void testWithPutAll(Method m) throws InterruptedException {
        LocalLockReorderingTest.runTest(StresserThread.PUT_ALL_PERFORMER, this.cache(0), this.cache(1), this.keys, this.getThreadPrefix(m));
    }

    public void testMixed(Method m) throws InterruptedException {
        LocalLockReorderingTest.runTest(StresserThread.MIXED_OPS_PERFORMER, this.cache(0), this.cache(1), this.keys, this.getThreadPrefix(m));
    }

    private String getThreadPrefix(Method m) {
        return this.getClass().getSimpleName() + "." + m.getName();
    }
}

