/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.recovery;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.transaction.xa.Xid;
import junit.framework.Assert;
import org.infinispan.config.Configuration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.tm.DummyTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.XaTransactionTable;
import org.infinispan.transaction.xa.recovery.RecoveryAwareTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.transaction.xa.recovery.RecoveryManagerImpl;
import org.infinispan.tx.recovery.RecoveryDummyTransactionManagerLookup;
import org.infinispan.tx.recovery.RecoveryTestUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.recovery.PostCommitRecoveryStateTest")
public class PostCommitRecoveryStateTest
extends MultipleCacheManagersTest {
    private static Log log = LogFactory.getLog(PostCommitRecoveryStateTest.class);

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration configuration = PostCommitRecoveryStateTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, true);
        configuration.fluent().locking().useLockStriping(Boolean.valueOf(false));
        configuration.fluent().transaction().transactionManagerLookupClass(RecoveryDummyTransactionManagerLookup.class).recovery();
        configuration.fluent().clustering().hash().rehashEnabled(Boolean.valueOf(false));
        this.createCluster(configuration, 2);
        this.waitForClusterToForm();
        ComponentRegistry componentRegistry = this.cache(0).getAdvancedCache().getComponentRegistry();
        XaTransactionTable txTable = (XaTransactionTable)componentRegistry.getComponent(TransactionTable.class);
        txTable.setRecoveryManager((RecoveryManager)new RecoveryManagerDelegate(txTable.getRecoveryManager()));
    }

    public void testState() throws Exception {
        RecoveryManagerImpl rm1 = (RecoveryManagerImpl)this.advancedCache(1).getComponentRegistry().getComponent(RecoveryManager.class);
        TransactionTable tt1 = (TransactionTable)this.advancedCache(1).getComponentRegistry().getComponent(TransactionTable.class);
        Assert.assertEquals((int)rm1.getInDoubtTransactionsMap().size(), (int)0);
        Assert.assertEquals((int)tt1.getRemoteTxCount(), (int)0);
        DummyTransaction t0 = RecoveryTestUtil.beginAndSuspendTx(this.cache(0));
        Assert.assertEquals((int)rm1.getInDoubtTransactionsMap().size(), (int)0);
        Assert.assertEquals((int)tt1.getRemoteTxCount(), (int)0);
        RecoveryTestUtil.prepareTransaction(t0);
        Assert.assertEquals((int)rm1.getInDoubtTransactionsMap().size(), (int)0);
        Assert.assertEquals((int)tt1.getRemoteTxCount(), (int)1);
        RecoveryTestUtil.commitTransaction(t0);
        Assert.assertEquals((int)tt1.getRemoteTxCount(), (int)1);
        Assert.assertEquals((int)rm1.getInDoubtTransactionsMap().size(), (int)0);
    }

    public static class RecoveryManagerDelegate
    implements RecoveryManager {
        volatile RecoveryManager rm;
        public boolean swallowRemoveRecoveryInfoCalls = true;

        public RecoveryManagerDelegate(RecoveryManager recoveryManager) {
            this.rm = recoveryManager;
        }

        public RecoveryManager.RecoveryIterator getPreparedTransactionsFromCluster() {
            return this.rm.getPreparedTransactionsFromCluster();
        }

        public void removeRecoveryInformationFromCluster(Collection<Address> where, Xid xid, boolean sync, GlobalTransaction gtx) {
            if (this.swallowRemoveRecoveryInfoCalls) {
                log.trace((Object)"PostCommitRecoveryStateTest$RecoveryManagerDelegate.removeRecoveryInformation");
            } else {
                this.rm.removeRecoveryInformationFromCluster(where, xid, sync, null);
            }
        }

        public void removeRecoveryInformationFromCluster(Collection<Address> where, long internalId, boolean sync) {
            this.rm.removeRecoveryInformationFromCluster(where, internalId, sync);
        }

        public RecoveryAwareTransaction removeRecoveryInformation(Xid xid) {
            this.rm.removeRecoveryInformation(xid);
            return null;
        }

        public Set<RecoveryManager.InDoubtTxInfo> getInDoubtTransactionInfoFromCluster() {
            return this.rm.getInDoubtTransactionInfoFromCluster();
        }

        public Set<RecoveryManager.InDoubtTxInfo> getInDoubtTransactionInfo() {
            return this.rm.getInDoubtTransactionInfo();
        }

        public List<Xid> getInDoubtTransactions() {
            return this.rm.getInDoubtTransactions();
        }

        public RecoveryAwareTransaction getPreparedTransaction(Xid xid) {
            return this.rm.getPreparedTransaction(xid);
        }

        public String forceTransactionCompletion(Xid xid, boolean commit) {
            return this.rm.forceTransactionCompletion(xid, commit);
        }

        public String forceTransactionCompletionFromCluster(Xid xid, Address where, boolean commit) {
            return this.rm.forceTransactionCompletionFromCluster(xid, where, commit);
        }

        public boolean isTransactionPrepared(GlobalTransaction globalTx) {
            return this.rm.isTransactionPrepared(globalTx);
        }

        public RecoveryAwareTransaction removeRecoveryInformation(Long internalId) {
            this.rm.removeRecoveryInformation(internalId);
            return null;
        }
    }
}

