/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jgroups;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.jgroups.MessageSerializationHelper;
import org.hibernate.search.backend.impl.jgroups.NodeSelectorStrategy;
import org.hibernate.search.backend.impl.jgroups.NodeSelectorStrategyHolder;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;

public class JGroupsMasterMessageListener
implements Receiver {
    private static final Log log = LoggerFactory.make();
    private final BuildContext context;
    private final NodeSelectorStrategyHolder selector;

    public JGroupsMasterMessageListener(BuildContext context, NodeSelectorStrategyHolder masterNodeSelector) {
        this.context = context;
        this.selector = masterNodeSelector;
    }

    public void receive(Message message) {
        block4: {
            byte[] rawBuffer = message.getRawBuffer();
            String indexName = MessageSerializationHelper.extractIndexName(rawBuffer);
            NodeSelectorStrategy nodeSelector = this.selector.getMasterNodeSelector(indexName);
            try {
                if (!nodeSelector.isIndexOwnerLocal()) break block4;
                byte[] serializedQueue = MessageSerializationHelper.extractSerializedQueue(rawBuffer);
                IndexManager indexManager = this.context.getAllIndexesManager().getIndexManager(indexName);
                if (indexManager != null) {
                    List<LuceneWork> queue = indexManager.getSerializer().toLuceneWorks(serializedQueue);
                    this.applyLuceneWorkLocally(queue, indexManager, message);
                    break block4;
                }
                log.messageReceivedForUndefinedIndex(indexName);
                return;
            }
            catch (ClassCastException e) {
                log.illegalObjectRetrievedFromMessage(e);
                return;
            }
            catch (SearchException e) {
                log.illegalObjectRetrievedFromMessage(e);
                return;
            }
        }
    }

    private void applyLuceneWorkLocally(List<LuceneWork> queue, IndexManager indexManager, Message message) {
        if (queue != null && !queue.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debugf("There are %d Lucene docs received from slave node %s to be processed by master", queue.size(), message.getSrc());
            }
            indexManager.performOperations(queue, null);
        } else {
            log.receivedEmptyLuceneWorksInMessage();
        }
    }

    public void viewAccepted(View view) {
        log.jGroupsReceivedNewClusterView(view);
        this.selector.viewAccepted(view);
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    public void getState(OutputStream arg0) throws Exception {
    }

    public void setState(InputStream arg0) throws Exception {
    }

    public void unblock() {
    }
}

