/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.NotifyingFuture;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.AsyncAPITest")
public class AsyncAPITest
extends SingleCacheManagerTest {
    Cache<String, String> c;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager(false);
        this.c = cm.getCache();
        return cm;
    }

    public void testAsyncMethods() throws ExecutionException, InterruptedException {
        NotifyingFuture f = this.c.getAsync((Object)"k");
        assert (f != null);
        assert (f.isDone());
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (this.c.get((Object)"k") == null);
        f = this.c.putAsync((Object)"k", (Object)"v");
        assert (f != null);
        assert (f.isDone());
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (((String)this.c.get((Object)"k")).equals("v"));
        f = this.c.putAsync((Object)"k", (Object)"v2");
        assert (f != null);
        assert (f.isDone());
        assert (!f.isCancelled());
        assert (((String)f.get()).equals("v"));
        assert (((String)this.c.get((Object)"k")).equals("v2"));
        NotifyingFuture f2 = this.c.putAllAsync(Collections.singletonMap("k", "v3"));
        assert (f2 != null);
        assert (f2.isDone());
        assert (!f2.isCancelled());
        assert (f2.get() == null);
        assert (((String)this.c.get((Object)"k")).equals("v3"));
        f = this.c.putIfAbsentAsync((Object)"k", (Object)"v4");
        assert (f != null);
        assert (f.isDone());
        assert (!f.isCancelled());
        assert (((String)f.get()).equals("v3"));
        assert (((String)this.c.get((Object)"k")).equals("v3"));
        f = this.c.removeAsync((Object)"k");
        assert (f != null);
        assert (f.isDone());
        assert (!f.isCancelled());
        assert (((String)f.get()).equals("v3"));
        assert (this.c.get((Object)"k") == null);
        f = this.c.putIfAbsentAsync((Object)"k", (Object)"v4");
        assert (f != null);
        assert (f.isDone());
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (((String)this.c.get((Object)"k")).equals("v4"));
        f = this.c.getAsync((Object)"k");
        assert (f != null);
        assert (f.isDone());
        assert (!f.isCancelled());
        assert (((String)f.get()).equals("v4"));
        assert (((String)this.c.get((Object)"k")).equals("v4"));
        NotifyingFuture f3 = this.c.removeAsync((Object)"k", (Object)"v_nonexistent");
        assert (f3 != null);
        assert (f3.isDone());
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(false));
        assert (((String)this.c.get((Object)"k")).equals("v4"));
        f3 = this.c.removeAsync((Object)"k", (Object)"v4");
        assert (f3 != null);
        assert (f3.isDone());
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(true));
        assert (this.c.get((Object)"k") == null);
        f = this.c.replaceAsync((Object)"k", (Object)"v5");
        assert (f != null);
        assert (f.isDone());
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (this.c.get((Object)"k") == null);
        this.c.put((Object)"k", (Object)"v");
        f = this.c.replaceAsync((Object)"k", (Object)"v5");
        assert (f != null);
        assert (f.isDone());
        assert (!f.isCancelled());
        assert (((String)f.get()).equals("v"));
        assert (((String)this.c.get((Object)"k")).equals("v5"));
        f3 = this.c.replaceAsync((Object)"k", (Object)"v_nonexistent", (Object)"v6");
        assert (f3 != null);
        assert (f3.isDone());
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(false));
        assert (((String)this.c.get((Object)"k")).equals("v5"));
        f3 = this.c.replaceAsync((Object)"k", (Object)"v5", (Object)"v6");
        assert (f3 != null);
        assert (f3.isDone());
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(true));
        assert (((String)this.c.get((Object)"k")).equals("v6"));
    }
}

