/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import org.infinispan.AdvancedCache;
import org.infinispan.config.Configuration;
import org.infinispan.config.QueryableDataContainer;
import org.infinispan.container.DataContainer;
import org.infinispan.container.DefaultDataContainer;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.InternalEntryFactoryImpl;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="config.DataContainerTest", groups={"functional"})
public class DataContainerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefault() throws IOException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><infinispan><default><dataContainer /></default></infinispan>";
        ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes());
        EmbeddedCacheManager cm = TestCacheManagerFactory.fromStream(stream);
        try {
            Assert.assertEquals((String)cm.getDefaultConfiguration().getDataContainerClass(), (String)DefaultDataContainer.class.getName());
            Assert.assertEquals(cm.getCache().getAdvancedCache().getDataContainer().getClass(), DefaultDataContainer.class);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomDataContainerClass() throws IOException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><infinispan><default><dataContainer class=\"" + QueryableDataContainer.class.getName() + "\">" + "<properties><property name=\"foo\" value=\"bar\" /></properties>" + "</dataContainer></default>" + "</infinispan>";
        ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes());
        EmbeddedCacheManager cm = TestCacheManagerFactory.fromStream(stream);
        try {
            AdvancedCache cache = cm.getCache().getAdvancedCache();
            DataContainer ddc = DefaultDataContainer.unBoundedDataContainer((int)cache.getConfiguration().getConcurrencyLevel());
            ((DefaultDataContainer)ddc).initialize(null, null, (InternalEntryFactory)new InternalEntryFactoryImpl());
            QueryableDataContainer.setDelegate(ddc);
            Assert.assertEquals((String)cm.getDefaultConfiguration().getDataContainer().getClass().getName(), (String)QueryableDataContainer.class.getName());
            Assert.assertEquals(cache.getDataContainer().getClass(), QueryableDataContainer.class);
            QueryableDataContainer dataContainer = (QueryableDataContainer)QueryableDataContainer.class.cast(cache.getDataContainer());
            Assert.assertFalse((boolean)this.checkLoggedOperations(dataContainer.getLoggedOperations(), "setFoo(bar)"));
            cache.put((Object)"name", (Object)"Pete");
            Assert.assertTrue((boolean)this.checkLoggedOperations(dataContainer.getLoggedOperations(), "put(name, Pete"));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomDataContainer() {
        Configuration configuration = new Configuration();
        configuration.fluent().dataContainer().dataContainer((DataContainer)new QueryableDataContainer());
        DefaultCacheManager cm = new DefaultCacheManager(configuration);
        try {
            AdvancedCache cache = cm.getCache().getAdvancedCache();
            DataContainer ddc = DefaultDataContainer.unBoundedDataContainer((int)cache.getConfiguration().getConcurrencyLevel());
            ((DefaultDataContainer)ddc).initialize(null, null, (InternalEntryFactory)new InternalEntryFactoryImpl());
            QueryableDataContainer.setDelegate(ddc);
            Assert.assertEquals(cm.getDefaultConfiguration().getDataContainer().getClass(), QueryableDataContainer.class);
            Assert.assertEquals(cache.getDataContainer().getClass(), QueryableDataContainer.class);
            QueryableDataContainer dataContainer = (QueryableDataContainer)QueryableDataContainer.class.cast(cache.getDataContainer());
            cache.put((Object)"name", (Object)"Pete");
            Assert.assertTrue((boolean)this.checkLoggedOperations(dataContainer.getLoggedOperations(), "put(name, Pete"));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(new EmbeddedCacheManager[]{cm});
            throw throwable;
        }
        TestingUtil.killCacheManagers(new EmbeddedCacheManager[]{cm});
    }

    boolean checkLoggedOperations(Collection<String> loggedOperations, String prefix) {
        for (String loggedOperation : loggedOperations) {
            if (!loggedOperation.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

