/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distexec.DistributedExecutorTest")
public class DistributedExecutorTest
extends BaseDistFunctionalTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        super.createCacheManagers();
    }

    public void testBasicInvocation() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        Future future = des.submit((Callable)new SimpleCallable());
        Integer r = (Integer)future.get();
        assert (r == 1);
    }

    public void testExceptionInvocation() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        Future future = des.submit((Callable)new ExceptionThrowingCallable());
        int exceptionCount = 0;
        try {
            future.get();
            throw new IllegalStateException("Should not have reached this code");
        }
        catch (ExecutionException ex) {
            assert (++exceptionCount == 1);
            List list = des.submitEverywhere((Callable)new ExceptionThrowingCallable());
            exceptionCount = 0;
            for (Future f : list) {
                try {
                    f.get();
                    throw new IllegalStateException("Should not have reached this code");
                }
                catch (ExecutionException ex2) {
                    ++exceptionCount;
                }
            }
            assert (exceptionCount == list.size());
            return;
        }
    }

    public void testRunnableInvocation() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        Future future = des.submit((Runnable)new BoringRunnable());
        Object object = future.get();
        assert (object == null);
        des.execute((Runnable)new BoringRunnable());
        int exceptionCount = 0;
        try {
            des.execute(new Runnable(){

                @Override
                public void run() {
                }
            });
            throw new Exception("Should not have happened");
        }
        catch (IllegalArgumentException iae) {
            assert (++exceptionCount == 1);
            return;
        }
    }

    public void testInvokeAny() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        ArrayList<SimpleCallable> tasks = new ArrayList<SimpleCallable>();
        tasks.add(new SimpleCallable());
        Integer result = (Integer)des.invokeAny(tasks);
        assert (result == 1);
        tasks = new ArrayList();
        tasks.add(new SimpleCallable());
        tasks.add(new SimpleCallable());
        result = (Integer)des.invokeAny(tasks);
        assert (result == 1);
    }

    public void testInvokeAll() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        ArrayList<SimpleCallable> tasks = new ArrayList<SimpleCallable>();
        tasks.add(new SimpleCallable());
        List list = des.invokeAll(tasks);
        assert (list.size() == 1);
        Future future = (Future)list.get(0);
        assert ((Integer)future.get() == 1);
        tasks = new ArrayList();
        tasks.add(new SimpleCallable());
        tasks.add(new SimpleCallable());
        tasks.add(new SimpleCallable());
        list = des.invokeAll(tasks);
        assert (list.size() == 3);
        for (Future f : list) {
            assert ((Integer)f.get() == 1);
        }
    }

    public void testCallableIsolation() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        List list = des.submitEverywhere((Callable)new SimpleCallableWithField());
        assert (list != null && !list.isEmpty());
        for (Future f : list) {
            assert ((Integer)f.get() == 0);
        }
    }

    public void testTaskCancellation() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.c2);
        Future future = des.submit((Callable)new SimpleCallable());
        if (future.cancel(true)) assert (future.isCancelled());
        assert (future.isDone());
    }

    public void testBasicDistributedCallable() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.c2);
        Future future = des.submit((Callable)((Object)new SimpleDistributedCallable(false)));
        Boolean r = (Boolean)future.get();
        assert (r.booleanValue());
    }

    public void testBasicDistributedCallableWitkKeys() throws Exception {
        this.c1.put((Object)"key1", (Object)"Manik");
        this.c1.put((Object)"key2", (Object)"Mircea");
        this.c1.put((Object)"key3", (Object)"Galder");
        this.c1.put((Object)"key4", (Object)"Sanne");
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        Future future = des.submit((Callable)((Object)new SimpleDistributedCallable(true)), (Object[])new String[]{"key1", "key2"});
        Boolean r = (Boolean)future.get();
        assert (r.booleanValue());
    }

    public void testDistributedCallableEverywhereWithKeys() throws Exception {
        this.c1.put((Object)"key1", (Object)"Manik");
        this.c1.put((Object)"key2", (Object)"Mircea");
        this.c1.put((Object)"key3", (Object)"Galder");
        this.c1.put((Object)"key4", (Object)"Sanne");
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        List list = des.submitEverywhere((Callable)((Object)new SimpleDistributedCallable(true)), (Object[])new String[]{"key1", "key2"});
        assert (list != null && !list.isEmpty());
        for (Future f : list) {
            assert (((Boolean)f.get()).booleanValue());
        }
    }

    public void testDistributedCallableEverywhere() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        List list = des.submitEverywhere((Callable)((Object)new SimpleDistributedCallable(false)));
        assert (list != null && !list.isEmpty());
        for (Future f : list) {
            assert (((Boolean)f.get()).booleanValue());
        }
    }

    static class BoringRunnable
    implements Runnable,
    Serializable {
        private static final long serialVersionUID = 6898519516955822402L;

        BoringRunnable() {
        }

        @Override
        public void run() {
            System.out.println("I am a boring runnable");
        }
    }

    static class ExceptionThrowingCallable
    implements Callable<Integer>,
    Serializable {
        private static final long serialVersionUID = -8682463816319507893L;

        ExceptionThrowingCallable() {
        }

        @Override
        public Integer call() throws Exception {
            throw new Exception("Intentional Exception from ExceptionThrowingCallable");
        }
    }

    static class SimpleCallableWithField
    implements Callable<Integer>,
    Serializable {
        private static final long serialVersionUID = -6262148927734766558L;
        private int count;

        SimpleCallableWithField() {
        }

        @Override
        public Integer call() throws Exception {
            return this.count++;
        }
    }

    static class SimpleCallable
    implements Callable<Integer>,
    Serializable {
        private static final long serialVersionUID = -8589149500259272402L;

        SimpleCallable() {
        }

        @Override
        public Integer call() throws Exception {
            return 1;
        }
    }

    static class SimpleDistributedCallable
    implements DistributedCallable<String, String, Boolean>,
    Serializable {
        private static final long serialVersionUID = 623845442163221832L;
        private boolean invokedProperly = false;
        private final boolean hasKeys;

        public SimpleDistributedCallable(boolean hasKeys) {
            this.hasKeys = hasKeys;
        }

        public Boolean call() throws Exception {
            return this.invokedProperly;
        }

        public void setEnvironment(Cache<String, String> cache, Set<String> inputKeys) {
            boolean keysProperlySet = this.hasKeys ? inputKeys != null && !inputKeys.isEmpty() : inputKeys != null && inputKeys.isEmpty();
            this.invokedProperly = cache != null && keysProperlySet;
        }

        public boolean validlyInvoked() {
            return this.invokedProperly;
        }
    }
}

