/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.config.Configuration;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.NotSerializableException;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.SingleOwnerTest")
public class SingleOwnerTest
extends BaseDistFunctionalTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        this.cacheName = "dist";
        this.configuration = SingleOwnerTest.getDefaultClusteredConfig(this.sync ? Configuration.CacheMode.DIST_SYNC : Configuration.CacheMode.DIST_ASYNC, this.tx);
        if (!this.testRetVals) {
            this.configuration.setUnsafeUnreliableReturnValues(true);
            this.configuration.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        }
        this.configuration.setSyncReplTimeout(3L, TimeUnit.SECONDS);
        this.configuration.setNumOwners(1);
        this.configuration.setLockAcquisitionTimeout(45L, TimeUnit.SECONDS);
        this.caches = this.createClusteredCaches(2, this.cacheName, this.configuration);
        this.c1 = (Cache)this.caches.get(0);
        this.c2 = (Cache)this.caches.get(1);
        this.cacheAddresses = new ArrayList(2);
        for (Cache cache : this.caches) {
            EmbeddedCacheManager cacheManager = cache.getCacheManager();
            this.cacheAddresses.add(cacheManager.getAddress());
        }
        this.waitForClusterToForm(this.cacheName);
    }

    public void testPutOnKeyOwner() {
        Cache<Object, String>[] caches = this.getOwners("mykey", 1);
        assert (caches.length == 1);
        Cache<Object, String> ownerCache = caches[0];
        ownerCache.put((Object)"mykey", new Object());
    }

    public void testClearOnKeyOwner() {
        Cache<Object, String>[] caches = this.getOwners("mykey", 1);
        assert (caches.length == 1);
        Cache<Object, String> ownerCache = caches[0];
        ownerCache.clear();
    }

    public void testRetrieveNonSerializableKeyFromNonOwner() {
        Cache<Object, String>[] owners = this.getOwners("yourkey", 1);
        Cache<Object, String>[] nonOwners = this.getNonOwners("yourkey", 1);
        assert (owners.length == 1);
        assert (nonOwners.length == 1);
        Cache<Object, String> ownerCache = owners[0];
        Cache<Object, String> nonOwnerCache = nonOwners[0];
        ownerCache.put((Object)"yourkey", new Object());
        try {
            nonOwnerCache.get((Object)"yourkey");
            assert (false) : "Should have failed with a org.infinispan.marshall.NotSerializableException";
        }
        catch (NotSerializableException e) {
            // empty catch block
        }
    }

    public void testErrorWhenRetrievingKeyFromNonOwner() {
        this.log.trace((Object)"Before test");
        Cache<Object, String>[] owners = this.getOwners("diffkey", 1);
        Cache<Object, String>[] nonOwners = this.getNonOwners("diffkey", 1);
        assert (owners.length == 1);
        assert (nonOwners.length == 1);
        Cache<Object, String> ownerCache = owners[0];
        Cache<Object, String> nonOwnerCache = nonOwners[0];
        ownerCache.put((Object)"diffkey", (Object)new Externalizable(){
            private static final long serialVersionUID = -483939825697574242L;

            @Override
            public void writeExternal(ObjectOutput out) throws IOException {
                throw new UnknownError();
            }

            @Override
            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }
        });
        try {
            nonOwnerCache.get((Object)"diffkey");
            assert (false) : "Should have failed with a CacheException that contains an UnknownError";
        }
        catch (CacheException e) {
            if (e.getCause() != null) {
                assert (e.getCause() instanceof UnknownError) : e.getCause();
            }
            throw e;
        }
    }
}

