/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.invalidation;

import org.infinispan.AdvancedCache;
import org.infinispan.config.Configuration;
import org.infinispan.marshall.NotSerializableException;
import org.infinispan.replication.ReplicationExceptionTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="invalidation.InvalidationExceptionTest")
public class InvalidationExceptionTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration invalidAsync = InvalidationExceptionTest.getDefaultClusteredConfig(Configuration.CacheMode.INVALIDATION_ASYNC, false);
        this.createClusteredCaches(2, "invalidAsync", invalidAsync);
        Configuration replQueue = InvalidationExceptionTest.getDefaultClusteredConfig(Configuration.CacheMode.INVALIDATION_ASYNC, false);
        replQueue.setUseReplQueue(true);
        this.defineConfigurationOnAllManagers("invalidReplQueueCache", replQueue);
        Configuration asyncMarshall = InvalidationExceptionTest.getDefaultClusteredConfig(Configuration.CacheMode.INVALIDATION_ASYNC, false);
        asyncMarshall.setUseAsyncMarshalling(true);
        this.defineConfigurationOnAllManagers("invalidAsyncMarshallCache", asyncMarshall);
    }

    public void testNonSerializableAsyncInvalid() throws Exception {
        this.doNonSerializableInvalidTest("invalidAsync");
    }

    public void testNonSerializableReplQueue() throws Exception {
        this.doNonSerializableInvalidTest("invalidReplQueueCache");
    }

    public void testNonSerializableAsyncMarshalling() throws Exception {
        this.doNonSerializableInvalidTest("invalidAsyncMarshallCache");
    }

    private void doNonSerializableInvalidTest(String cacheName) {
        AdvancedCache cache1 = this.cache(0, cacheName).getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, cacheName).getAdvancedCache();
        try {
            cache1.put((Object)new ReplicationExceptionTest.ContainerData(), (Object)("test-" + cacheName));
            AssertJUnit.assertNotNull((String)"NonSerializableData should not be null on cache2", (Object)cache2.get((Object)"test"));
        }
        catch (RuntimeException runtime) {
            Throwable t = runtime.getCause();
            if (runtime instanceof NotSerializableException || t instanceof NotSerializableException || t.getCause() instanceof NotSerializableException) {
                System.out.println("received NotSerializableException - as expected");
            }
            throw runtime;
        }
    }
}

