/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.dummy;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.AbstractCacheStore;
import org.infinispan.loaders.AbstractCacheStoreConfig;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.loaders.CacheStore;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@CacheLoaderMetadata(configurationClass=Cfg.class)
public class DummyInMemoryCacheStore
extends AbstractCacheStore {
    private static final Log log = LogFactory.getLog(DummyInMemoryCacheStore.class);
    private static final boolean trace = log.isTraceEnabled();
    static final ConcurrentMap<String, Map<Object, InternalCacheEntry>> stores = new ConcurrentHashMap<String, Map<Object, InternalCacheEntry>>();
    static final ConcurrentMap<String, ConcurrentMap<String, Integer>> storeStats = new ConcurrentHashMap<String, ConcurrentMap<String, Integer>>();
    String storeName;
    Map<Object, InternalCacheEntry> store;
    ConcurrentMap<String, Integer> stats;
    Cfg config;

    public DummyInMemoryCacheStore(String storeName) {
        this.storeName = storeName;
    }

    public DummyInMemoryCacheStore() {
    }

    private void record(String method) {
        boolean replaced;
        long end = System.currentTimeMillis() + 5000L;
        do {
            int i;
            if (replaced = this.stats.replace(method, i = ((Integer)this.stats.get(method)).intValue(), i + 1)) continue;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } while (!replaced && end < System.currentTimeMillis());
    }

    public void store(InternalCacheEntry ed) {
        this.record("store");
        if (ed != null) {
            if (trace) {
                log.tracef("Store %s in dummy map store@%s", (Object)ed, (Object)Util.hexIdHashCode(this.store));
            }
            this.config.failIfNeeded(ed.getKey());
            this.store.put(ed.getKey(), ed);
        }
    }

    public void fromStream(ObjectInput ois) throws CacheLoaderException {
        this.record("fromStream");
        try {
            int numEntries = (Integer)this.marshaller.objectFromObjectStream(ois);
            for (int i = 0; i < numEntries; ++i) {
                InternalCacheEntry e = (InternalCacheEntry)this.marshaller.objectFromObjectStream(ois);
                if (trace) {
                    log.tracef("Store %s from stream in dummy store@%s", (Object)e, (Object)Util.hexIdHashCode(this.store));
                }
                this.store.put(e.getKey(), e);
            }
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
    }

    public void toStream(ObjectOutput oos) throws CacheLoaderException {
        this.record("toStream");
        try {
            this.marshaller.objectToObjectStream((Object)this.store.size(), oos);
            for (InternalCacheEntry se : this.store.values()) {
                this.marshaller.objectToObjectStream((Object)se, oos);
            }
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
    }

    public void clear() {
        this.record("clear");
        if (trace) {
            log.trace((Object)"Clear store");
        }
        this.store.clear();
    }

    public boolean remove(Object key) {
        this.record("remove");
        if (this.store.remove(key) != null) {
            if (trace) {
                log.tracef("Removed %s from dummy store", key);
            }
            return true;
        }
        if (trace) {
            log.tracef("Key %s not present in store, so don't remove", key);
        }
        return false;
    }

    protected void purgeInternal() throws CacheLoaderException {
        long currentTimeMillis = System.currentTimeMillis();
        Iterator<InternalCacheEntry> i = this.store.values().iterator();
        while (i.hasNext()) {
            InternalCacheEntry se = i.next();
            if (!se.isExpired(currentTimeMillis)) continue;
            i.remove();
        }
    }

    public void init(CacheLoaderConfig config, Cache cache, StreamingMarshaller m) throws CacheLoaderException {
        super.init(config, cache, m);
        this.config = (Cfg)config;
        this.storeName = this.config.getStoreName();
        if (this.marshaller == null) {
            this.marshaller = new TestObjectStreamMarshaller();
        }
    }

    public InternalCacheEntry load(Object key) {
        this.record("load");
        if (key == null) {
            return null;
        }
        InternalCacheEntry se = this.store.get(key);
        if (se == null) {
            return null;
        }
        if (se.isExpired(System.currentTimeMillis())) {
            log.debugf("Key %s exists, but has expired.  Entry is %s", key, (Object)se);
            this.store.remove(key);
            return null;
        }
        return se;
    }

    public Set<InternalCacheEntry> loadAll() {
        this.record("loadAll");
        HashSet<InternalCacheEntry> s = new HashSet<InternalCacheEntry>();
        long currentTimeMillis = System.currentTimeMillis();
        Iterator<InternalCacheEntry> i = this.store.values().iterator();
        while (i.hasNext()) {
            InternalCacheEntry se = i.next();
            if (se.isExpired(currentTimeMillis)) {
                log.debugf("Key %s exists, but has expired.  Entry is %s", se.getKey(), (Object)se);
                i.remove();
                continue;
            }
            s.add(se);
        }
        return s;
    }

    public Set<InternalCacheEntry> load(int numEntries) throws CacheLoaderException {
        this.record("load");
        if (numEntries < 0) {
            return this.loadAll();
        }
        HashSet<InternalCacheEntry> s = new HashSet<InternalCacheEntry>(numEntries);
        long currentTimeMillis = System.currentTimeMillis();
        Iterator<InternalCacheEntry> i = this.store.values().iterator();
        while (i.hasNext() && s.size() < numEntries) {
            InternalCacheEntry se = i.next();
            if (se.isExpired(currentTimeMillis)) {
                log.debugf("Key %s exists, but has expired.  Entry is %s", se.getKey(), (Object)se);
                i.remove();
                continue;
            }
            if (s.size() >= numEntries) continue;
            s.add(se);
        }
        return s;
    }

    public Set<Object> loadAllKeys(Set<Object> keysToExclude) throws CacheLoaderException {
        this.record("loadAllKeys");
        HashSet<Object> set = new HashSet<Object>();
        for (Object key : this.store.keySet()) {
            if (keysToExclude != null && keysToExclude.contains(key)) continue;
            set.add(key);
        }
        return set;
    }

    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        this.record("getConfigurationClass");
        return Cfg.class;
    }

    public void start() throws CacheLoaderException {
        super.start();
        if (this.store != null) {
            return;
        }
        this.store = new ConcurrentHashMap<Object, InternalCacheEntry>();
        this.stats = this.newStatsMap();
        if (this.storeName != null) {
            Map<Object, InternalCacheEntry> existing;
            if (this.cache != null) {
                this.storeName = this.storeName + "_" + this.cache.getName();
            }
            if ((existing = stores.putIfAbsent(this.storeName, this.store)) != null) {
                this.store = existing;
                log.debugf("Reusing in-memory cache store %s", (Object)this.storeName);
            } else {
                log.debugf("Creating new in-memory cache store %s", (Object)this.storeName);
            }
            ConcurrentMap<String, Integer> existingStats = storeStats.putIfAbsent(this.storeName, this.stats);
            if (existing != null) {
                this.stats = existingStats;
            }
        }
        this.record("start");
    }

    private ConcurrentMap<String, Integer> newStatsMap() {
        ConcurrentHashMap<String, Integer> m = new ConcurrentHashMap<String, Integer>();
        for (Method method : CacheStore.class.getMethods()) {
            m.put(method.getName(), 0);
        }
        return m;
    }

    public void stop() throws CacheLoaderException {
        String storeName;
        this.record("stop");
        super.stop();
        if (this.config.isPurgeOnStartup().booleanValue() && (storeName = this.config.getStoreName()) != null) {
            stores.remove(storeName);
        }
    }

    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    public Map<String, Integer> stats() {
        return Collections.unmodifiableMap(this.stats);
    }

    public void clearStats() {
        for (String k : this.stats.keySet()) {
            this.stats.put(k, 0);
        }
    }

    public static class Cfg
    extends AbstractCacheStoreConfig {
        private static final long serialVersionUID = 4258914047690999424L;
        boolean debug;
        String storeName = null;
        private Object failKey;

        public Cfg() {
            this(null);
        }

        public Cfg(String name) {
            this.setCacheLoaderClassName(DummyInMemoryCacheStore.class.getName());
            this.storeName(name);
        }

        public boolean isDebug() {
            return this.debug;
        }

        @Deprecated
        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        public Cfg debug(boolean debug) {
            this.setDebug(debug);
            return this;
        }

        public String getStoreName() {
            return this.storeName;
        }

        @Deprecated
        public void setStoreName(String store) {
            this.storeName = store;
        }

        public Cfg storeName(String store) {
            this.setStoreName(store);
            return this;
        }

        public Cfg clone() {
            return (Cfg)super.clone();
        }

        @Deprecated
        public void setFailKey(Object failKey) {
            this.failKey = failKey;
        }

        public Cfg failKey(Object failKey) {
            this.setFailKey(failKey);
            return this;
        }

        public void failIfNeeded(Object key) {
            if (this.failKey != null && this.failKey.equals(key)) {
                throw new RuntimeException("Induced failure on key:" + key);
            }
        }

        public Cfg fetchPersistentState(Boolean fetchPersistentState) {
            super.fetchPersistentState(fetchPersistentState);
            return this;
        }

        public Cfg ignoreModifications(Boolean ignoreModifications) {
            super.ignoreModifications(ignoreModifications);
            return this;
        }

        public Cfg purgeOnStartup(Boolean purgeOnStartup) {
            super.purgeOnStartup(purgeOnStartup);
            return this;
        }

        public Cfg purgerThreads(Integer purgerThreads) {
            super.purgerThreads(purgerThreads);
            return this;
        }

        public Cfg purgeSynchronously(Boolean purgeSynchronously) {
            super.purgeSynchronously(purgeSynchronously);
            return this;
        }
    }
}

