/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.tm.DummyTransaction;
import org.infinispan.tx.dld.ControlledRpcManager;

public abstract class AbstractCrashTest
extends MultipleCacheManagersTest {
    protected Configuration.CacheMode cacheMode;
    protected LockingMode lockingMode;
    protected Boolean useSynchronization;

    protected AbstractCrashTest(Configuration.CacheMode cacheMode, LockingMode lockingMode, Boolean useSynchronization) {
        this.cacheMode = cacheMode;
        this.lockingMode = lockingMode;
        this.useSynchronization = useSynchronization;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = this.buildConfiguration();
        this.createCluster(c, 3);
        this.waitForClusterToForm();
    }

    protected Configuration buildConfiguration() {
        Configuration c = AbstractCrashTest.getDefaultClusteredConfig(this.cacheMode);
        c.fluent().transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).useSynchronization(this.useSynchronization).lockingMode(this.lockingMode);
        c.fluent().hash().rehashEnabled(Boolean.valueOf(false)).numOwners(Integer.valueOf(3));
        c.fluent().clustering().l1().disable();
        return c;
    }

    protected Object beginAndPrepareTx(final Object k, final int cacheIndex) {
        this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractCrashTest.this.tm(cacheIndex).begin();
                    AbstractCrashTest.this.cache(cacheIndex).put(k, (Object)"v");
                    DummyTransaction transaction = (DummyTransaction)AbstractCrashTest.this.tm(cacheIndex).getTransaction();
                    transaction.runPrepare();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }, false);
        return k;
    }

    protected Object beginAndCommitTx(final Object k, final int cacheIndex) {
        this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractCrashTest.this.tm(cacheIndex).begin();
                    AbstractCrashTest.this.cache(cacheIndex).put(k, (Object)"v");
                    AbstractCrashTest.this.tm(cacheIndex).commit();
                }
                catch (Throwable e) {
                    AbstractCrashTest.this.log.errorf(e, "Error committing transaction for key %s on cache %s", k, (Object)AbstractCrashTest.this.cache(cacheIndex));
                }
            }
        }, false);
        return k;
    }

    protected void prepareCache(final CountDownLatch releaseLocksLatch) {
        ControlledRpcManager rpcManager = new ControlledRpcManager(this.advancedCache(1).getRpcManager()){

            @Override
            public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, boolean sync, boolean usePriorityQueue) {
                if (rpcCommand instanceof TxCompletionNotificationCommand) {
                    releaseLocksLatch.countDown();
                    return null;
                }
                return this.realOne.invokeRemotely(recipients, rpcCommand, sync, usePriorityQueue);
            }
        };
        TransactionTable transactionTable = TestingUtil.getTransactionTable(this.cache(1));
        TestingUtil.replaceField(rpcManager, "rpcManager", transactionTable, TransactionTable.class);
        TxControlInterceptor txControlInterceptor = new TxControlInterceptor();
        txControlInterceptor.prepareProgress.countDown();
        txControlInterceptor.commitProgress.countDown();
        this.advancedCache(1).addInterceptor((CommandInterceptor)txControlInterceptor, 1);
    }

    public static class TxControlInterceptor
    extends CommandInterceptor {
        public CountDownLatch prepareProgress = new CountDownLatch(1);
        public CountDownLatch preparedReceived = new CountDownLatch(1);
        public CountDownLatch commitReceived = new CountDownLatch(1);
        public CountDownLatch commitProgress = new CountDownLatch(1);

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            Object result = super.visitPrepareCommand(ctx, command);
            this.preparedReceived.countDown();
            this.prepareProgress.await();
            return result;
        }

        public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
            this.commitReceived.countDown();
            this.commitProgress.await();
            return super.visitCommitCommand(ctx, command);
        }
    }
}

