/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.profiling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, enabled=true, testName="profiling.DeadlockDetectionPerformanceTest")
public class DeadlockDetectionPerformanceTest
extends AbstractInfinispanTest {
    private static final Log log = LogFactory.getLog(DeadlockDetectionPerformanceTest.class);
    public static final int KEY_POOL_SIZE = 10;
    public static int TX_SIZE = 5;
    public static int THREAD_COUNT = 5;
    public static final long BENCHMARK_DURATION = 60000L;
    public static boolean NO_COLISION = false;
    public static boolean USE_DLD = true;
    public static List<String> keyPool;

    @BeforeTest
    public void generateKeyPool() {
        keyPool = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            keyPool.add("key" + i);
        }
    }

    @Test(invocationCount=10, enabled=false)
    public void testLocalDifferentTxSize() throws Exception {
        USE_DLD = false;
        int i = 2;
        while (i < 10) {
            TX_SIZE = i++;
            this.runLocalTest();
        }
        USE_DLD = true;
        i = 2;
        while (i < 10) {
            TX_SIZE = i++;
            this.runLocalTest();
        }
    }

    @Test(invocationCount=5, enabled=false)
    public void testLocalDifferentTxSizeNoCollision() throws Exception {
        NO_COLISION = true;
        USE_DLD = false;
        int i = 2;
        while (i < 10) {
            TX_SIZE = i++;
            this.runLocalTest();
        }
        USE_DLD = true;
        i = 2;
        while (i < 10) {
            TX_SIZE = i++;
            this.runLocalTest();
        }
    }

    @Test(invocationCount=10, enabled=false)
    public void testReplDifferentTxSize() throws Exception {
        THREAD_COUNT = 2;
        USE_DLD = false;
        int i = 2;
        while (i < 10) {
            TX_SIZE = i++;
            this.runDistributedTest();
        }
        USE_DLD = true;
        i = 2;
        while (i < 10) {
            TX_SIZE = i++;
            this.runDistributedTest();
        }
    }

    @Test(invocationCount=5, enabled=false)
    public void testReplDifferentTxSizeDldOnly() throws Exception {
        THREAD_COUNT = 3;
        USE_DLD = true;
        int i = 2;
        while (i < 10) {
            TX_SIZE = i++;
            this.runDistributedTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDistributedTest() throws Exception {
        EmbeddedCacheManager cm = null;
        ArrayList<EmbeddedCacheManager> containers = new ArrayList<EmbeddedCacheManager>();
        try {
            CountDownLatch startLatch = new CountDownLatch(1);
            ArrayList<ExecutorThread> executorThreads = new ArrayList<ExecutorThread>();
            for (int i = 0; i < THREAD_COUNT; ++i) {
                cm = TestCacheManagerFactory.createClusteredCacheManager();
                Configuration configuration = this.getConfiguration();
                configuration.setCacheMode(Configuration.CacheMode.REPL_SYNC);
                cm.defineConfiguration("test", configuration);
                Cache distCache = cm.getCache("test");
                ExecutorThread executorThread = new ExecutorThread(startLatch, distCache);
                executorThreads.add(executorThread);
                containers.add(cm);
            }
            TestingUtil.blockUntilViewsReceived(10000L, containers.toArray(new CacheContainer[containers.size()]));
            startLatch.countDown();
            Thread.sleep(60000L);
            this.joinThreadsAndPrintResult(executorThreads);
        }
        finally {
            log.trace((Object)("About to kill cache managers: " + containers));
            TestingUtil.killCacheManagers(containers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLocalTest() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager(false);
        try {
            Configuration configuration = this.getConfiguration();
            cm.defineConfiguration("test", configuration);
            Cache localCache = cm.getCache("test");
            CountDownLatch startLatch = new CountDownLatch(1);
            ArrayList<ExecutorThread> executorThreads = new ArrayList<ExecutorThread>();
            for (int i = 0; i < THREAD_COUNT; ++i) {
                ExecutorThread executorThread = new ExecutorThread(startLatch, localCache);
                executorThreads.add(executorThread);
            }
            startLatch.countDown();
            Thread.sleep(60000L);
            this.joinThreadsAndPrintResult(executorThreads);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    private void joinThreadsAndPrintResult(List<ExecutorThread> executorThreads) throws InterruptedException {
        int totalSuccess = 0;
        int totalFailures = 0;
        for (int i = 0; i < THREAD_COUNT; ++i) {
            ExecutorThread executorThread = executorThreads.get(i);
            executorThread.join();
            totalSuccess += executorThread.getSuccessfullTx();
            totalFailures += executorThread.getFailedTx();
        }
        System.out.println("Use DDL? " + USE_DLD + " TX_SIZE = " + TX_SIZE + " totalSuccess = " + totalSuccess);
        System.out.println("Use DDL? " + USE_DLD + " TX_SIZE = " + TX_SIZE + " totalFailures = " + totalFailures);
        System.out.println("-------------------------------");
    }

    private Configuration getConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        configuration.setEnableDeadlockDetection(USE_DLD);
        configuration.setUseLockStriping(false);
        return configuration;
    }

    private static List<String> getKeysPerTx() {
        Random rnd = new Random();
        HashSet<String> result = new HashSet<String>();
        while (result.size() < TX_SIZE) {
            String key = keyPool.get(rnd.nextInt(10));
            result.add(key);
        }
        ArrayList<String> resultList = new ArrayList<String>(result);
        if (!NO_COLISION) {
            Collections.shuffle(resultList);
        }
        return resultList;
    }

    public static class ExecutorThread
    extends Thread {
        private volatile CountDownLatch startLatch;
        private volatile int successfullTx;
        private volatile int failedTx;
        private volatile Cache cache;
        private volatile TransactionManager txManager;
        static int TX_INDEX = 0;

        public ExecutorThread(CountDownLatch startLatch, Cache cache) {
            super("EXECUTOR-THREAD-" + TX_INDEX++);
            this.startLatch = startLatch;
            this.cache = cache;
            this.txManager = TestingUtil.getTransactionManager(cache);
            this.start();
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            try {
                this.startLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while (start + 60000L - System.currentTimeMillis() > 0L) {
                try {
                    this.txManager.begin();
                    List keysToUpdate = DeadlockDetectionPerformanceTest.getKeysPerTx();
                    for (String key : keysToUpdate) {
                        this.cache.put((Object)key, (Object)"value");
                    }
                    this.txManager.commit();
                    ++this.successfullTx;
                }
                catch (Throwable e) {
                    ++this.failedTx;
                }
            }
            this.info("Exiting thread " + this.getName() + " which lived " + (System.currentTimeMillis() - start) + " milliseconds");
        }

        private void info(String s) {
            System.out.println("[" + this.getName() + "] " + s);
            log.trace((Object)s);
        }

        public int getFailedTx() {
            return this.failedTx;
        }

        public int getSuccessfullTx() {
            return this.successfullTx;
        }
    }
}

