/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting;

import java.io.EOFException;
import java.lang.reflect.InvocationTargetException;
import java.util.EmptyStackException;
import org.easymock.EasyMock;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.CommandAwareRpcDispatcher;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.jgroups.blocks.RpcDispatcher;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="remoting.TransportSenderExceptionHandlingTest")
public class TransportSenderExceptionHandlingTest
extends MultipleCacheManagersTest {
    final String key = "k-illyria";
    final String value = "v-illyria";
    final String value2 = "v2-illyria";

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createClusteredCaches(2, "replSync", TransportSenderExceptionHandlingTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAndExceptionWhileUnmarshalling() throws Exception {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        JGroupsTransport transport1 = (JGroupsTransport)TestingUtil.extractComponent(cache1, Transport.class);
        CommandAwareRpcDispatcher dispatcher1 = transport1.getCommandAwareRpcDispatcher();
        RpcDispatcher.Marshaller originalMarshaller1 = dispatcher1.getMarshaller();
        JGroupsTransport transport2 = (JGroupsTransport)TestingUtil.extractComponent(cache2, Transport.class);
        CommandAwareRpcDispatcher dispatcher2 = transport2.getCommandAwareRpcDispatcher();
        RpcDispatcher.Marshaller originalMarshaller = dispatcher2.getMarshaller();
        try {
            RpcDispatcher.Marshaller mockMarshaller1 = (RpcDispatcher.Marshaller)EasyMock.createMock(RpcDispatcher.Marshaller.class);
            RpcDispatcher.Marshaller mockMarshaller = (RpcDispatcher.Marshaller)EasyMock.createMock(RpcDispatcher.Marshaller.class);
            PutKeyValueCommand putCommand = new PutKeyValueCommand();
            putCommand.setKey((Object)"k-illyria");
            putCommand.setValue((Object)"v-illyria");
            SingleRpcCommand rpcCommand = new SingleRpcCommand("replSync");
            Object[] params = new Object[]{putCommand};
            rpcCommand.setParameters(1, params);
            EasyMock.expect((Object)mockMarshaller1.objectToBuffer(EasyMock.anyObject())).andReturn((Object)originalMarshaller1.objectToBuffer((Object)rpcCommand));
            EasyMock.expect((Object)mockMarshaller.objectFromBuffer((byte[])EasyMock.anyObject(), EasyMock.anyInt(), EasyMock.anyInt())).andThrow((Throwable)new EOFException());
            dispatcher1.setRequestMarshaller(mockMarshaller1);
            dispatcher2.setRequestMarshaller(mockMarshaller);
            EasyMock.replay((Object[])new Object[]{mockMarshaller1, mockMarshaller});
            cache1.put((Object)"k-illyria", (Object)"v-illyria");
            assert (false) : "Should have thrown an exception";
        }
        catch (CacheException ce) {
            assert (!(ce.getCause() instanceof ClassCastException)) : "No way a ClassCastException must be sent back to user!";
            assert (ce.getCause() instanceof EOFException);
        }
        finally {
            dispatcher1.setMarshaller(originalMarshaller1);
            dispatcher2.setMarshaller(originalMarshaller);
        }
    }

    @Test(expectedExceptions={ArrayStoreException.class})
    public void testThrowExceptionFromRemoteListener() throws Throwable {
        this.induceListenerMalfunctioning(false, FailureType.EXCEPTION_FROM_LISTENER);
    }

    @Test(expectedExceptions={NoClassDefFoundError.class})
    public void testThrowErrorFromRemoteListener() throws Throwable {
        this.induceListenerMalfunctioning(true, FailureType.ERROR_FROM_LISTENER);
    }

    @Test(expectedExceptions={EmptyStackException.class})
    public void testThrowExceptionFromRemoteInterceptor() throws Throwable {
        this.induceInterceptorMalfunctioning(FailureType.EXCEPTION_FROM_INTERCEPTOR);
    }

    @Test(expectedExceptions={ClassCircularityError.class})
    public void testThrowErrorFromRemoteInterceptor() throws Throwable {
        this.induceInterceptorMalfunctioning(FailureType.ERROR_FROM_INTERCEPTOR);
    }

    private void induceInterceptorMalfunctioning(FailureType failureType) throws Throwable {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        cache2.getAdvancedCache().addInterceptorAfter((CommandInterceptor)new ErrorInducingInterceptor(), NonTransactionalLockingInterceptor.class);
        this.log.info((Object)"Before put.");
        try {
            cache1.put((Object)failureType, (Object)1);
        }
        catch (CacheException e) {
            throw e.getCause();
        }
        finally {
            cache2.getAdvancedCache().removeInterceptor(ErrorInducingInterceptor.class);
        }
    }

    private void induceListenerMalfunctioning(boolean throwError, FailureType failureType) throws Throwable {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        ErrorInducingListener listener = new ErrorInducingListener(throwError);
        cache2.addListener((Object)listener);
        try {
            cache1.put((Object)failureType, (Object)1);
        }
        catch (CacheException e) {
            if (throwError && e.getCause() instanceof InvocationTargetException) {
                throw e.getCause().getCause();
            }
            throw e.getCause();
        }
        finally {
            cache2.removeListener((Object)listener);
        }
    }

    static class ErrorInducingInterceptor
    extends CommandInterceptor {
        ErrorInducingInterceptor() {
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            Object k = command.getKey();
            if (k == FailureType.EXCEPTION_FROM_INTERCEPTOR) {
                throw new EmptyStackException();
            }
            if (k == FailureType.ERROR_FROM_INTERCEPTOR) {
                throw new ClassCircularityError();
            }
            return super.visitPutKeyValueCommand(ctx, command);
        }
    }

    static enum FailureType {
        EXCEPTION_FROM_LISTENER,
        ERROR_FROM_LISTENER,
        EXCEPTION_FROM_INTERCEPTOR,
        ERROR_FROM_INTERCEPTOR;

    }

    @Listener
    public static class ErrorInducingListener {
        final boolean throwError;

        public ErrorInducingListener(boolean throwError) {
            this.throwError = throwError;
        }

        @CacheEntryCreated
        public void entryCreated(CacheEntryEvent event) throws Exception {
            if (event.isPre() && this.shouldFail(event)) {
                if (this.throwError) {
                    throw new NoClassDefFoundError("Simulated error...");
                }
                throw new ArrayStoreException("A failure...");
            }
        }

        private boolean shouldFail(CacheEntryEvent event) {
            Object key = event.getKey();
            return key == FailureType.EXCEPTION_FROM_LISTENER || key == FailureType.ERROR_FROM_LISTENER;
        }
    }
}

