/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.statetransfer.BigObject;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.StateTransferLargeObjectTest")
public class StateTransferLargeObjectTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(StateTransferLargeObjectTest.class);
    private Cache c0;
    private Cache c1;
    private Cache c2;
    private Cache c3;
    private Map<Integer, BigObject> cache;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration config = StateTransferLargeObjectTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC);
        config.setL1CacheEnabled(false);
        config.setNumOwners(3);
        config.setUseLockStriping(false);
        this.createCluster(config, 4);
        this.c0 = this.cache(0);
        this.c1 = this.cache(1);
        this.c2 = this.cache(2);
        this.c3 = this.cache(3);
        this.waitForClusterToForm();
        log.info((Object)"Rehash is complete!");
        this.cache = new HashMap<Integer, BigObject>();
    }

    public void testForFailure() {
        int i;
        int num = 1000;
        for (i = 0; i < num; ++i) {
            BigObject bigObject = this.createBigObject(i, "prefix");
            this.cache.put(i, bigObject);
            this.c0.put((Object)i, (Object)bigObject);
        }
        for (i = 0; i < num; ++i) {
            assert (this.c0.get((Object)i) instanceof BigObject);
            assert (this.c1.get((Object)i) instanceof BigObject);
            assert (this.c2.get((Object)i) instanceof BigObject);
            assert (this.c3.get((Object)i) instanceof BigObject);
        }
        log.info((Object)"Before stopping a cache!");
        Thread thread = new Thread(){

            @Override
            public void run() {
                log.info((Object)("About to stop " + StateTransferLargeObjectTest.this.c3.getAdvancedCache().getRpcManager().getAddress()));
                StateTransferLargeObjectTest.this.c3.stop();
                StateTransferLargeObjectTest.this.c3.getCacheManager().stop();
                log.info((Object)"Cache stopped async!");
            }
        };
        thread.start();
        int failureCount = 0;
        for (int i2 = 0; i2 < num; ++i2) {
            log.info((Object)("----Running a get on " + i2));
            try {
                Object o = this.c0.get((Object)i2);
                this.assertValue(i2, o);
            }
            catch (TimeoutException e) {
                log.error((Object)"Exception received", (Throwable)e);
                ++failureCount;
            }
            try {
                this.assertValue(i2, this.c1.get((Object)i2));
            }
            catch (TimeoutException e) {
                ++failureCount;
            }
            try {
                this.assertValue(i2, this.c2.get((Object)i2));
            }
            catch (TimeoutException e) {
                ++failureCount;
            }
            if (i2 % 100 != 0) continue;
            System.out.println("i = " + i2);
        }
        log.info((Object)("failureCount = " + failureCount));
        log.info((Object)"Before stopping cache managers!");
        TestingUtil.killCacheManagers(this.manager(2));
        log.info((Object)"2 killed");
        TestingUtil.killCacheManagers(this.manager(1));
        log.info((Object)"1 killed");
        TestingUtil.killCacheManagers(this.manager(0));
        log.info((Object)"0 killed");
    }

    private void assertValue(int i, Object o) {
        String msg = " expected some value for " + i + " but got " + o;
        if (!(o instanceof BigObject)) {
            log.error((Object)msg);
        }
        Assert.assertEquals((Object)o, (Object)this.cache.get(i));
    }

    private BigObject createBigObject(int num, String prefix) {
        BigObject obj = new BigObject();
        obj.setName("[" + num + "|" + prefix + "|" + num * 3 + "|" + num * 7 + "]");
        obj.setValue(this.generateLargeString());
        obj.setValue2(this.generateLargeString());
        obj.setValue3(this.generateLargeString());
        obj.setValue4(this.generateLargeString());
        obj.setValue5(this.generateLargeString());
        obj.setValue6(this.generateLargeString());
        obj.setValue7(this.generateLargeString());
        obj.setValue8(this.generateLargeString());
        obj.setValue9(this.generateLargeString());
        obj.setValue10(this.generateLargeString());
        obj.setValue11(this.generateLargeString());
        obj.setValue12(this.generateLargeString());
        obj.setValue13(this.generateLargeString());
        obj.setValue14(this.generateLargeString());
        obj.setValue15(this.generateLargeString());
        obj.setValue16(this.generateLargeString());
        obj.setValue17(this.generateLargeString());
        obj.setValue18(this.generateLargeString());
        obj.setValue19(this.generateLargeString());
        obj.setValue20(this.generateLargeString());
        return obj;
    }

    private String generateLargeString() {
        Random rnd = new Random();
        byte[] bytes = new byte[100];
        rnd.nextBytes(bytes);
        return new String(bytes);
    }

    @Override
    @AfterMethod
    protected void clearContent() throws Throwable {
    }
}

