/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.concurrent.CountDownLatch;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.tm.DummyTransaction;
import org.infinispan.transaction.tm.DummyTransactionManager;
import org.testng.annotations.Test;

@Test(testName="tx.StaleLockAfterTxAbortTest", groups={"unit"})
public class StaleLockAfterTxAbortTest
extends SingleCacheManagerTest {
    final String k = "key";

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration c = this.getDefaultStandaloneConfig(true);
        c.fluent().transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        return TestCacheManagerFactory.createCacheManager(c);
    }

    public void doTest() throws Throwable {
        this.cache.put((Object)"key", (Object)"value");
        this.assertNotLocked(this.cache, "key");
        DummyTransactionManager dtm = (DummyTransactionManager)this.tm();
        this.tm().begin();
        this.cache.put((Object)"key", (Object)"some");
        DummyTransaction transaction = dtm.getTransaction();
        transaction.runPrepare();
        this.tm().suspend();
        this.assertLocked(this.cache, "key");
        CountDownLatch txStartedLatch = new CountDownLatch(1);
        TxThread transactionThread = new TxThread(this.cache, txStartedLatch);
        transactionThread.start();
        txStartedLatch.countDown();
        Thread.sleep(500L);
        transactionThread.tm.resume(transactionThread.tx);
        transactionThread.tm.rollback();
        this.tm().resume((Transaction)transaction);
        transaction.runRollback();
        transactionThread.join();
        this.assertNotLocked(this.cache, "key");
    }

    private class TxThread
    extends Thread {
        final Cache<Object, Object> cache;
        volatile Transaction tx;
        volatile Exception exception;
        final TransactionManager tm;
        final CountDownLatch txStartedLatch;

        private TxThread(Cache<Object, Object> cache, CountDownLatch txStartedLatch) {
            this.cache = cache;
            this.tx = null;
            this.tm = cache.getAdvancedCache().getTransactionManager();
            this.txStartedLatch = txStartedLatch;
        }

        @Override
        public void run() {
            try {
                this.tm.begin();
                this.tx = this.tm.getTransaction();
                System.out.println("Started transaction " + this.tx);
                this.txStartedLatch.countDown();
                this.cache.put((Object)"key", (Object)"v2");
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }
}

