/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.exception;

import java.util.HashMap;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.locks.LockManager;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="tx.TxAndTimeoutExceptionTest", groups={"functional"})
public class TxAndTimeoutExceptionTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration config = this.getDefaultStandaloneConfig(true);
        config.fluent().transaction().lockingMode(LockingMode.PESSIMISTIC);
        config.setUseLockStriping(false);
        config.setLockAcquisitionTimeout(1000L);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(config);
        this.cache = cm.getCache();
        return cm;
    }

    public void testPutTimeoutsInTx() throws Exception {
        this.assertExpectedBehavior(new CacheOperation(){

            @Override
            public void execute() {
                TxAndTimeoutExceptionTest.this.cache.put((Object)"k1", (Object)"v2222");
            }
        });
    }

    public void testRemoveTimeoutsInTx() throws Exception {
        this.assertExpectedBehavior(new CacheOperation(){

            @Override
            public void execute() {
                TxAndTimeoutExceptionTest.this.cache.remove((Object)"k1");
            }
        });
    }

    public void testClearTimeoutsInTx() throws Exception {
        this.cache.put((Object)"k1", (Object)"value");
        this.assertExpectedBehavior(new CacheOperation(){

            @Override
            public void execute() {
                TxAndTimeoutExceptionTest.this.cache.clear();
            }
        });
    }

    public void testReplaceTimeoutsInTx() throws Exception {
        this.assertExpectedBehavior(new CacheOperation(){

            @Override
            public void execute() {
                TxAndTimeoutExceptionTest.this.cache.replace((Object)"k1", (Object)"newValue");
            }
        });
    }

    public void testPutAllTimeoutsInTx() throws Exception {
        this.assertExpectedBehavior(new CacheOperation(){

            @Override
            public void execute() {
                HashMap<String, String> toAdd = new HashMap<String, String>();
                toAdd.put("k1", "v22222");
                TxAndTimeoutExceptionTest.this.cache.putAll(toAdd);
            }
        });
    }

    private void assertExpectedBehavior(CacheOperation op) throws Exception {
        LockManager lm = TestingUtil.extractLockManager(this.cache);
        TransactionTable txTable = TestingUtil.getTransactionTable((Cache<Object, Object>)this.cache);
        TransactionManager tm = this.cache.getAdvancedCache().getTransactionManager();
        tm.begin();
        this.cache.put((Object)"k1", (Object)"v1");
        Transaction k1LockOwner = tm.suspend();
        assert (lm.isLocked((Object)"k1"));
        Assert.assertEquals((int)1, (int)txTable.getLocalTxCount());
        tm.begin();
        this.cache.put((Object)"k2", (Object)"v2");
        assert (lm.isLocked((Object)"k2"));
        Assert.assertEquals((int)2, (int)txTable.getLocalTxCount());
        assert (tm.getTransaction() != null);
        try {
            op.execute();
            assert (false) : "Timeout exception expected";
        }
        catch (TimeoutException e) {
            // empty catch block
        }
        Transaction transaction = tm.getTransaction();
        assert (transaction != null);
        assert (transaction.getStatus() == 1);
        assert (!lm.isLocked((Object)"k2"));
        assert (lm.isLocked((Object)"k1"));
        try {
            this.cache.put((Object)"k3", (Object)"v3");
            assert (false);
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        Assert.assertEquals((int)txTable.getLocalTxCount(), (int)1);
        tm.rollback();
        Assert.assertEquals((int)txTable.getLocalTxCount(), (int)1);
        tm.resume(k1LockOwner);
        tm.commit();
        Assert.assertEquals((int)0, (int)txTable.getLocalTxCount());
        Assert.assertEquals((Object)this.cache.get((Object)"k1"), (Object)"v1");
        assert (!lm.isLocked((Object)"k1"));
        Assert.assertEquals((int)txTable.getLocalTxCount(), (int)0);
    }

    public static interface CacheOperation {
        public void execute();
    }
}

