/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jgroups;

import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.search.backend.impl.jgroups.NodeSelectorStrategy;
import org.hibernate.search.backend.impl.jgroups.NodeSelectorStrategyHolder;
import org.jgroups.Address;
import org.jgroups.View;

final class NodeSelectorStrategyHolderImplementation
implements NodeSelectorStrategyHolder {
    private ConcurrentHashMap<String, NodeSelectorStrategy> register = new ConcurrentHashMap(16, 0.75f, 2);
    private Address address;
    private View view;

    NodeSelectorStrategyHolderImplementation() {
    }

    @Override
    public NodeSelectorStrategy getMasterNodeSelector(String indexName) {
        return this.register.get(indexName);
    }

    @Override
    public synchronized void setNodeSelectorStrategy(String indexName, NodeSelectorStrategy selector) {
        this.register.put(indexName, selector);
        if (this.address != null) {
            selector.setLocalAddress(this.address);
        }
        if (this.view != null) {
            selector.viewAccepted(this.view);
        }
    }

    @Override
    public synchronized void setLocalAddress(Address address) {
        this.address = address;
        for (NodeSelectorStrategy s : this.register.values()) {
            s.setLocalAddress(address);
        }
    }

    @Override
    public synchronized void viewAccepted(View view) {
        this.view = view;
        for (NodeSelectorStrategy s : this.register.values()) {
            s.viewAccepted(view);
        }
    }
}

