/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cacheviews;

import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.util.Util;
import org.jgroups.protocols.DISCARD;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="cacheviews.CacheViewsManagerRecoverViewsTest")
@CleanupAfterMethod
public class CacheViewsManagerRecoverViewsTest
extends MultipleCacheManagersTest {
    Cache c1;
    Cache c2;
    DISCARD d1;
    DISCARD d2;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createClusteredCaches(2, "cache", CacheViewsManagerRecoverViewsTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC), new TransportFlags().withFD(true).withMerge(true));
        this.c1 = this.cache(0, "cache");
        this.c2 = this.cache(1, "cache");
        this.d1 = TestingUtil.getDiscardForCache(this.c1);
        this.d1.setExcludeItself(true);
        this.d2 = TestingUtil.getDiscardForCache(this.c2);
        this.d2.setExcludeItself(true);
    }

    public void testRecoverLoop() throws Exception {
        for (int i = 0; i < 3; ++i) {
            this.log.debugf("Splitting the cluster in two", new Object[0]);
            this.d1.setDiscardAll(true);
            this.d2.setDiscardAll(true);
            TestingUtil.blockUntilViewsReceived(60000L, false, this.c1);
            TestingUtil.waitForRehashToComplete(this.c1);
            TestingUtil.blockUntilViewsReceived(60000L, false, this.c2);
            TestingUtil.waitForRehashToComplete(this.c2);
            this.log.debugf("Merging the cluster partitions", new Object[0]);
            this.d1.setDiscardAll(false);
            this.d2.setDiscardAll(false);
            long startTime = System.currentTimeMillis();
            TestingUtil.blockUntilViewsReceived(30000L, this.c1, this.c2);
            TestingUtil.waitForRehashToComplete(this.c1, this.c2);
            long endTime = System.currentTimeMillis();
            this.log.debugf("Merge took %s", (Object)Util.prettyPrintTime((long)(endTime - startTime)));
            assert (endTime - startTime < 30000L) : "Merge took too long: " + Util.prettyPrintTime((long)(endTime - startTime));
        }
        this.log.debugf("Test finished without any failure", new Object[0]);
    }
}

