/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import org.infinispan.CacheException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.annotations.Test;

@Test(testName="container.versioning.LocalWriteSkewTest", groups={"functional"})
@CleanupAfterMethod
public class LocalWriteSkewTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        builder.versioning().enable().scheme(VersioningScheme.SIMPLE).locking().isolationLevel(IsolationLevel.REPEATABLE_READ).writeSkewCheck(true).transaction().lockingMode(LockingMode.OPTIMISTIC);
        DefaultCacheManager cm = new DefaultCacheManager(builder.build());
        builder.locking().writeSkewCheck(false).versioning().disable();
        cm.defineConfiguration("no-ws-chk", builder.build());
        return cm;
    }

    public void testWriteSkewEnabled() throws Exception {
        this.cache.put((Object)"hello", (Object)"world 1");
        this.tm().begin();
        Object v = this.cache.get((Object)"hello");
        assert ("world 1".equals(v));
        Transaction t = this.tm().suspend();
        this.cache.put((Object)"hello", (Object)"world 3");
        this.tm().resume(t);
        try {
            this.cache.put((Object)"hello", (Object)"world 2");
            assert (false) : "Should have detected write skew";
        }
        catch (CacheException e) {
            // empty catch block
        }
        try {
            this.tm().commit();
            assert (false) : "Transaction should roll back";
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        assert ("world 3".equals(this.cache.get((Object)"hello")));
    }

    public void testWriteSkewMultiEntries() throws Exception {
        this.tm().begin();
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2");
        this.tm().commit();
        this.tm().begin();
        this.cache.put((Object)"k2", (Object)"v2000");
        Object v = this.cache.get((Object)"k1");
        assert ("v1".equals(v));
        assert ("v2000".equals(this.cache.get((Object)"k2")));
        Transaction t = this.tm().suspend();
        this.cache.put((Object)"k1", (Object)"v3");
        this.tm().resume(t);
        try {
            this.cache.put((Object)"k1", (Object)"v5000");
            assert (false) : "Should have detected write skew";
        }
        catch (CacheException e) {
            // empty catch block
        }
        try {
            this.tm().commit();
            assert (false) : "Transaction should roll back";
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        assert ("v3".equals(this.cache.get((Object)"k1")));
        assert ("v2".equals(this.cache.get((Object)"k2")));
    }

    public void testWriteSkewDisabled() throws Exception {
        this.cache = this.cacheManager.getCache("no-ws-chk");
        this.cache.put((Object)"hello", (Object)"world 1");
        this.tm().begin();
        Object v = this.cache.get((Object)"hello");
        assert ("world 1".equals(v));
        Transaction t = this.tm().suspend();
        this.cache.put((Object)"hello", (Object)"world 3");
        this.tm().resume(t);
        this.cache.put((Object)"hello", (Object)"world 2");
        this.tm().commit();
        assert ("world 2".equals(this.cache.get((Object)"hello")));
    }

    public void testNullEntries() throws Exception {
        this.cache.put((Object)"hello", (Object)"world");
        this.tm().begin();
        assert ("world".equals(this.cache.get((Object)"hello")));
        Transaction t = this.tm().suspend();
        this.cache.remove((Object)"hello");
        assert (null == this.cache.get((Object)"hello"));
        this.tm().resume(t);
        try {
            this.cache.put((Object)"hello", (Object)"world2");
            assert (false) : "Write skew should have been detected";
        }
        catch (CacheException expected) {
            // empty catch block
        }
        try {
            this.tm().commit();
            assert (false) : "This transaction should roll back";
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        assert (null == this.cache.get((Object)"hello"));
    }
}

