/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.annotations.Test;

@Test(testName="container.versioning.VersionedReplStateTransferTest", groups={"functional"})
@CleanupAfterMethod
public class VersionedReplStateTransferTest
extends MultipleCacheManagersTest {
    ConfigurationBuilder builder;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.builder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        this.builder.clustering().cacheMode(CacheMode.REPL_SYNC).versioning().enable().scheme(VersioningScheme.SIMPLE).locking().isolationLevel(IsolationLevel.REPEATABLE_READ).writeSkewCheck(true).transaction().lockingMode(LockingMode.OPTIMISTIC).syncCommitPhase(true);
        this.createCluster(this.builder, 2);
        this.waitForClusterToForm();
    }

    public void testStateTransfer() throws Exception {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        cache0.put((Object)"hello", (Object)"world");
        assert ("world".equals(cache0.get((Object)"hello")));
        assert ("world".equals(cache1.get((Object)"hello")));
        this.tm(1).begin();
        assert ("world".equals(cache1.get((Object)"hello")));
        Transaction t = this.tm(1).suspend();
        this.addClusterEnabledCacheManager(this.builder);
        Cache cache2 = this.cache(2);
        assert ("world".equals(cache2.get((Object)"hello")));
        ((EmbeddedCacheManager)this.cacheManagers.get(0)).stop();
        cache2.put((Object)"hello", (Object)"new world");
        this.tm(1).resume(t);
        cache1.put((Object)"hello", (Object)"world2");
        try {
            this.tm(1).commit();
            assert (false) : "Should fail";
        }
        catch (RollbackException expected) {
            // empty catch block
        }
        assert ("new world".equals(this.cache(1).get((Object)"hello")));
        assert ("new world".equals(this.cache(2).get((Object)"hello")));
    }
}

