/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.Callable;
import org.infinispan.Cache;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.distexec.DistributedExecutionCompletionService;
import org.infinispan.distexec.DistributedExecutorService;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.NotifyingFuture;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distexec.DistributedExecutionCompletionTest")
public class DistributedExecutionCompletionTest
extends BaseDistFunctionalTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        super.createCacheManagers();
    }

    public void testBasicInvocation() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        DistributedExecutionCompletionService decs = new DistributedExecutionCompletionService((DistributedExecutorService)des);
        decs.submit((Callable)new SimpleCallable());
        NotifyingFuture future = decs.take();
        Integer r = (Integer)future.get();
        assert (r == 1);
    }

    public void testBasicDistributedCallableWitkKeys() throws Exception {
        this.c1.put((Object)"key1", (Object)"Manik");
        this.c1.put((Object)"key2", (Object)"Mircea");
        this.c1.put((Object)"key3", (Object)"Galder");
        this.c1.put((Object)"key4", (Object)"Sanne");
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        DistributedExecutionCompletionService decs = new DistributedExecutionCompletionService((DistributedExecutorService)des);
        decs.submit((Callable)((Object)new SimpleDistributedCallable(true)), (Object[])new String[]{"key1", "key2"});
        NotifyingFuture future = decs.take();
        Boolean r = (Boolean)future.get();
        assert (r.booleanValue());
    }

    public void testDistributedCallableEverywhereWithKeys() throws Exception {
        this.c1.put((Object)"key1", (Object)"Manik");
        this.c1.put((Object)"key2", (Object)"Mircea");
        this.c1.put((Object)"key3", (Object)"Galder");
        this.c1.put((Object)"key4", (Object)"Sanne");
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        DistributedExecutionCompletionService decs = new DistributedExecutionCompletionService((DistributedExecutorService)des);
        decs.submitEverywhere((Callable)((Object)new SimpleDistributedCallable(true)), (Object[])new String[]{"key1", "key2"});
        TestingUtil.sleepThread(1000L);
        NotifyingFuture f = null;
        int counter = 0;
        while ((f = decs.poll()) != null) {
            assert (((Boolean)f.get()).booleanValue());
            ++counter;
        }
        assert (counter > 0);
    }

    public void testDistributedCallableEverywhere() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        DistributedExecutionCompletionService decs = new DistributedExecutionCompletionService((DistributedExecutorService)des);
        decs.submitEverywhere((Callable)((Object)new SimpleDistributedCallable(false)));
        TestingUtil.sleepThread(1000L);
        NotifyingFuture f = null;
        int counter = 0;
        while ((f = decs.poll()) != null) {
            assert (((Boolean)f.get()).booleanValue());
            ++counter;
        }
        assert (counter > 0);
    }

    static class SimpleCallable
    implements Callable<Integer>,
    Serializable {
        private static final long serialVersionUID = -8589149500259272402L;

        SimpleCallable() {
        }

        @Override
        public Integer call() throws Exception {
            return 1;
        }
    }

    static class SimpleDistributedCallable
    implements DistributedCallable<String, String, Boolean>,
    Serializable {
        private static final long serialVersionUID = 623845442163221832L;
        private boolean invokedProperly = false;
        private final boolean hasKeys;

        public SimpleDistributedCallable(boolean hasKeys) {
            this.hasKeys = hasKeys;
        }

        public Boolean call() throws Exception {
            return this.invokedProperly;
        }

        public void setEnvironment(Cache<String, String> cache, Set<String> inputKeys) {
            boolean keysProperlySet = this.hasKeys ? inputKeys != null && !inputKeys.isEmpty() : inputKeys != null && inputKeys.isEmpty();
            this.invokedProperly = cache != null && keysProperlySet;
        }

        public boolean validlyInvoked() {
            return this.invokedProperly;
        }
    }
}

